/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.game.player.rotation;

import com.mentalfrostbyte.jello.util.game.player.rotation.NeuralNetwork;
import com.mentalfrostbyte.jello.util.game.player.rotation.ReinforcementManager;
import com.mentalfrostbyte.jello.util.game.player.rotation.RotationManager;
import com.mentalfrostbyte.jello.util.game.player.rotation.TrainingManager;
import com.mentalfrostbyte.jello.util.game.world.EntityRayTraceResult;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;

public class JelloAI {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final NeuralNetwork neuralNetwork = new NeuralNetwork();
    private static final RotationManager rotationManager = new RotationManager();
    private static final TrainingManager trainingManager = new TrainingManager(neuralNetwork);
    private static final ReinforcementManager reinforcementManager = new ReinforcementManager(neuralNetwork, trainingManager);
    private static JelloAI instance;
    public static final float HIT_REWARD = 1.0f;
    public static final float MISS_PENALTY = -0.2f;

    public static void init() {
        instance = new JelloAI();
        rotationManager.initialize();
        neuralNetwork.initialize();
        trainingManager.initialize();
        trainingManager.startTrainingThread();
    }

    public static void updateRotations() {
        rotationManager.updateRotations();
    }

    public static float getCurrentYaw() {
        return rotationManager.getCurrentYaw();
    }

    public static float getCurrentPitch() {
        return rotationManager.getCurrentPitch();
    }

    public static void applyServerRotation() {
        float pitchDiff;
        if (JelloAI.mc.player == null) {
            return;
        }
        float originalYaw = JelloAI.mc.player.rotationYaw;
        float originalPitch = JelloAI.mc.player.rotationPitch;
        float serverYaw = rotationManager.getCurrentYaw();
        float serverPitch = rotationManager.getCurrentPitch();
        float maxYawChange = 30.0f;
        float maxPitchChange = 15.0f;
        float yawDiff = MathHelper.wrapDegrees(serverYaw - JelloAI.mc.player.prevRotationYaw);
        if (Math.abs(yawDiff) > maxYawChange) {
            serverYaw = JelloAI.mc.player.prevRotationYaw + maxYawChange * Math.signum(yawDiff);
        }
        if (Math.abs(pitchDiff = serverPitch - JelloAI.mc.player.prevRotationPitch) > maxPitchChange) {
            serverPitch = JelloAI.mc.player.prevRotationPitch + maxPitchChange * Math.signum(pitchDiff);
        }
        JelloAI.mc.player.rotationYaw = serverYaw;
        JelloAI.mc.player.rotationPitch = serverPitch;
    }

    public static float[] getRotationsToPosition(double x, double y, double z) {
        if (JelloAI.mc.player == null) {
            return new float[2];
        }
        float[] inputs = JelloAI.getPositionInputs(x, y, z);
        float[] rotations = neuralNetwork.predict(inputs);
        if (rotations == null || rotations.length < 2) {
            return new float[2];
        }
        float yawDegrees = MathHelper.wrapDegrees(rotations[0] * 180.0f);
        float pitchDegrees = MathHelper.clamp(rotations[1] * 90.0f, -90.0f, 90.0f);
        return new float[]{yawDegrees, pitchDegrees};
    }

    public static void faceBlock(BlockPos pos) {
        if (pos == null || JelloAI.mc.player == null) {
            return;
        }
        float[] inputs = JelloAI.getBlockInputs(pos);
        float[] rotations = neuralNetwork.predict(inputs);
        if (rotations == null || rotations.length < 2) {
            return;
        }
        float yawDegrees = MathHelper.wrapDegrees(rotations[0] * 180.0f);
        float pitchDegrees = MathHelper.clamp(rotations[1] * 90.0f, -90.0f, 90.0f);
        float[] idealRotations = JelloAI.calculateIdealBlockRotations(pos);
        float[] expectedOutputs = JelloAI.normalizeRotations(idealRotations[0], idealRotations[1]);
        trainingManager.addTrainingSample(inputs, expectedOutputs, 1.0f);
        rotationManager.setTargetRotation(yawDegrees, pitchDegrees);
    }

    public static void faceEntity(Entity entity) {
        if (entity == null || JelloAI.mc.player == null) {
            return;
        }
        float[] inputs = JelloAI.getEntityInputs(entity);
        float[] rotations = neuralNetwork.predict(inputs);
        if (rotations == null || rotations.length < 2) {
            return;
        }
        float yawDegrees = MathHelper.wrapDegrees(rotations[0] * 180.0f);
        float pitchDegrees = MathHelper.clamp(rotations[1] * 90.0f, -90.0f, 90.0f);
        float[] idealRotations = JelloAI.calculateIdealRotations(entity);
        float[] expectedOutputs = JelloAI.normalizeRotations(idealRotations[0], idealRotations[1]);
        trainingManager.addTrainingSample(inputs, expectedOutputs, 1.0f);
        rotationManager.setTargetRotation(yawDegrees, pitchDegrees);
    }

    private static float[] getEntityInputs(Entity entity) {
        if (entity == null || JelloAI.mc.player == null) {
            return new float[8];
        }
        float[] inputs = new float[8];
        double playerX = JelloAI.mc.player.getPosX();
        double playerY = JelloAI.mc.player.getPosY() + (double)JelloAI.mc.player.getEyeHeight();
        double playerZ = JelloAI.mc.player.getPosZ();
        double entityX = entity.getPosX();
        double entityY = entity.getPosY() + (double)entity.getEyeHeight();
        double entityZ = entity.getPosZ();
        double diffX = entityX - playerX;
        double diffY = entityY - playerY;
        double diffZ = entityZ - playerZ;
        inputs[0] = (float)(diffX / 20.0);
        inputs[1] = (float)(diffY / 10.0);
        inputs[2] = (float)(diffZ / 20.0);
        inputs[3] = (float)(entity.getMotion().x / 2.0);
        inputs[4] = (float)(entity.getMotion().y / 2.0);
        inputs[5] = (float)(entity.getMotion().z / 2.0);
        inputs[6] = JelloAI.mc.player.rotationYaw / 180.0f;
        inputs[7] = JelloAI.mc.player.rotationPitch / 90.0f;
        if (inputs.length >= 10) {
            inputs[8] = (float)(JelloAI.mc.player.getMotion().x / 0.3);
            inputs[9] = (float)(JelloAI.mc.player.getMotion().z / 0.3);
        }
        return inputs;
    }

    private static float[] getBlockInputs(BlockPos pos) {
        if (pos == null || JelloAI.mc.player == null) {
            return new float[8];
        }
        float[] inputs = new float[8];
        double playerX = JelloAI.mc.player.getPosX();
        double playerY = JelloAI.mc.player.getPosY() + (double)JelloAI.mc.player.getEyeHeight();
        double playerZ = JelloAI.mc.player.getPosZ();
        double blockX = (double)pos.getX() + 0.5;
        double blockY = (double)pos.getY() + 0.5;
        double blockZ = (double)pos.getZ() + 0.5;
        double diffX = blockX - playerX;
        double diffY = blockY - playerY;
        double diffZ = blockZ - playerZ;
        inputs[0] = (float)(diffX / 20.0);
        inputs[1] = (float)(diffY / 10.0);
        inputs[2] = (float)(diffZ / 20.0);
        inputs[3] = 0.0f;
        inputs[4] = 0.0f;
        inputs[5] = 0.0f;
        inputs[6] = JelloAI.mc.player.rotationYaw / 180.0f;
        inputs[7] = JelloAI.mc.player.rotationPitch / 90.0f;
        return inputs;
    }

    private static float[] getPositionInputs(double targetX, double targetY, double targetZ) {
        if (JelloAI.mc.player == null) {
            return new float[8];
        }
        float[] inputs = new float[8];
        double playerX = JelloAI.mc.player.getPosX();
        double playerY = JelloAI.mc.player.getPosY() + (double)JelloAI.mc.player.getEyeHeight();
        double playerZ = JelloAI.mc.player.getPosZ();
        double diffX = targetX - playerX;
        double diffY = targetY - playerY;
        double diffZ = targetZ - playerZ;
        inputs[0] = (float)(diffX / 20.0);
        inputs[1] = (float)(diffY / 10.0);
        inputs[2] = (float)(diffZ / 20.0);
        inputs[3] = 0.0f;
        inputs[4] = 0.0f;
        inputs[5] = 0.0f;
        inputs[6] = JelloAI.mc.player.rotationYaw / 180.0f;
        inputs[7] = JelloAI.mc.player.rotationPitch / 90.0f;
        return inputs;
    }

    private static float[] calculateIdealRotations(Entity entity) {
        double playerX = JelloAI.mc.player.getPosX();
        double playerY = JelloAI.mc.player.getPosY() + (double)JelloAI.mc.player.getEyeHeight();
        double playerZ = JelloAI.mc.player.getPosZ();
        double entityX = entity.getPosX();
        double entityY = entity.getPosY() + (double)entity.getEyeHeight();
        double entityZ = entity.getPosZ();
        double diffX = entityX - playerX;
        double diffY = entityY - playerY;
        double diffZ = entityZ - playerZ;
        double dist = Math.sqrt(diffX * diffX + diffZ * diffZ);
        float idealYaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
        idealYaw = MathHelper.wrapDegrees(idealYaw);
        float idealPitch = (float)(-(Math.atan2(diffY, dist) * 180.0 / Math.PI));
        return new float[]{idealYaw, idealPitch};
    }

    private static float[] calculateIdealBlockRotations(BlockPos pos) {
        double playerX = JelloAI.mc.player.getPosX();
        double playerY = JelloAI.mc.player.getPosY() + (double)JelloAI.mc.player.getEyeHeight();
        double playerZ = JelloAI.mc.player.getPosZ();
        double blockX = (double)pos.getX() + 0.5;
        double blockY = (double)pos.getY() + 0.5;
        double blockZ = (double)pos.getZ() + 0.5;
        double diffX = blockX - playerX;
        double diffY = blockY - playerY;
        double diffZ = blockZ - playerZ;
        double dist = Math.sqrt(diffX * diffX + diffZ * diffZ);
        float idealYaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
        idealYaw = MathHelper.wrapDegrees(idealYaw);
        float idealPitch = (float)(-(Math.atan2(diffY, dist) * 180.0 / Math.PI));
        return new float[]{idealYaw, idealPitch};
    }

    public static float[] normalizeRotations(float yaw, float pitch) {
        return new float[]{yaw / 180.0f, pitch / 90.0f};
    }

    public static void recordHit(Entity entity, boolean wasMoving) {
        if (instance == null || entity == null || JelloAI.mc.player == null) {
            return;
        }
        float currentYaw = rotationManager.getCurrentYaw();
        float currentPitch = rotationManager.getCurrentPitch();
        float[] normalizedRotations = JelloAI.normalizeRotations(currentYaw, currentPitch);
        reinforcementManager.recordHit(entity, wasMoving, normalizedRotations[0], normalizedRotations[1]);
    }

    public static void recordMiss(Entity entity) {
        if (instance == null || entity == null || JelloAI.mc.player == null) {
            return;
        }
        float[] idealRotations = JelloAI.calculateIdealRotations(entity);
        idealRotations[0] = MathHelper.wrapDegrees(idealRotations[0]);
        float[] normalizedRotations = JelloAI.normalizeRotations(idealRotations[0], idealRotations[1]);
        float[] inputs = JelloAI.getEntityInputs(entity);
        float[] expectedOutputs = new float[]{normalizedRotations[0], normalizedRotations[1]};
        reinforcementManager.recordMiss(entity, inputs, expectedOutputs);
    }

    public static void onTick() {
        Entity target;
        if (JelloAI.mc.objectMouseOver != null && JelloAI.mc.objectMouseOver.getType() == RayTraceResult.Type.ENTITY && (target = ((EntityRayTraceResult)JelloAI.mc.objectMouseOver).getEntity()) != null) {
            JelloAI.faceEntity(target);
        }
        rotationManager.updateRotations();
        JelloAI.applyServerRotation();
    }
}

