/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.util.client.music;

import com.mentalfrostbyte.jello.util.client.music.Transform;

public class JavaFFT
implements Transform {
    private static final int MAX_FAST_BITS = 16;
    private static final int[][] FFT_BIT_TABLE = new int[16][];
    private final int numberOfSamples;
    private final int[] reverseIndices;
    private final float[] frequencies;

    public JavaFFT(int numberOfSamples) {
        if (!JavaFFT.isPowerOfTwo(numberOfSamples)) {
            throw new IllegalArgumentException("N is not a power of 2");
        }
        if (numberOfSamples <= 0) {
            throw new IllegalArgumentException("N must be greater than 0");
        }
        this.numberOfSamples = numberOfSamples;
        int numberOfBits = JavaFFT.getNumberOfNeededBits(numberOfSamples);
        this.reverseIndices = new int[numberOfSamples];
        for (int i = 0; i < numberOfSamples; ++i) {
            int j;
            this.reverseIndices[i] = j = JavaFFT.fastReverseBits(i, numberOfBits);
        }
        this.frequencies = new float[numberOfSamples];
        for (int index = 0; index < numberOfSamples; ++index) {
            this.frequencies[index] = index <= numberOfSamples / 2 ? (float)index / (float)numberOfSamples : -((float)(numberOfSamples - index) / (float)numberOfSamples);
        }
    }

    @Override
    public float[][] inverseTransform(float[] real, float[] imaginary) throws UnsupportedOperationException {
        float[][] out = new float[2][real.length];
        this.transform(true, real, imaginary, out[0], out[1]);
        return out;
    }

    @Override
    public float[][] transform(float[] real) throws UnsupportedOperationException {
        float[][] out = new float[3][real.length];
        this.transform(false, real, null, out[0], out[1]);
        out[2] = (float[])this.frequencies.clone();
        return out;
    }

    @Override
    public float[][] transform(float[] real, float[] imaginary) throws UnsupportedOperationException {
        float[][] out = new float[3][real.length];
        this.transform(false, real, imaginary, out[0], out[1]);
        out[2] = (float[])this.frequencies.clone();
        return out;
    }

    public void transform(boolean inverse, float[] realIn, float[] imaginaryIn, float[] realOut, float[] imaginaryOut) {
        int i;
        if (realIn.length != this.numberOfSamples) {
            throw new IllegalArgumentException("Number of samples must be " + this.numberOfSamples + " for this instance of JavaFFT");
        }
        for (i = 0; i < this.numberOfSamples; ++i) {
            realOut[this.reverseIndices[i]] = realIn[i];
        }
        if (imaginaryIn != null) {
            for (i = 0; i < this.numberOfSamples; ++i) {
                imaginaryOut[this.reverseIndices[i]] = imaginaryIn[i];
            }
        }
        int blockEnd = 1;
        double angleNumerator = inverse ? Math.PI * -2 : Math.PI * 2;
        for (int blockSize = 2; blockSize <= this.numberOfSamples; blockSize <<= 1) {
            double deltaAngle = angleNumerator / (double)blockSize;
            double sm2 = -Math.sin(-2.0 * deltaAngle);
            double sm1 = -Math.sin(-deltaAngle);
            double cm2 = Math.cos(-2.0 * deltaAngle);
            double cm1 = Math.cos(-deltaAngle);
            double w = 2.0 * cm1;
            for (int i2 = 0; i2 < this.numberOfSamples; i2 += blockSize) {
                double ar2 = cm2;
                double ar1 = cm1;
                double ai2 = sm2;
                double ai1 = sm1;
                int j = i2;
                for (int n = 0; n < blockEnd; ++n) {
                    double ar0 = w * ar1 - ar2;
                    ar2 = ar1;
                    ar1 = ar0;
                    double ai0 = w * ai1 - ai2;
                    ai2 = ai1;
                    ai1 = ai0;
                    int k = j + blockEnd;
                    double tr = ar0 * (double)realOut[k] - ai0 * (double)imaginaryOut[k];
                    double ti = ar0 * (double)imaginaryOut[k] + ai0 * (double)realOut[k];
                    realOut[k] = (float)((double)realOut[j] - tr);
                    imaginaryOut[k] = (float)((double)imaginaryOut[j] - ti);
                    int n2 = j;
                    realOut[n2] = realOut[n2] + (float)tr;
                    int n3 = j++;
                    imaginaryOut[n3] = imaginaryOut[n3] + (float)ti;
                }
            }
            blockEnd = blockSize;
        }
        if (inverse) {
            int i3 = 0;
            while (i3 < this.numberOfSamples) {
                int n = i3;
                realOut[n] = realOut[n] / (float)this.numberOfSamples;
                int n4 = i3++;
                imaginaryOut[n4] = imaginaryOut[n4] / (float)this.numberOfSamples;
            }
        }
    }

    private static int getNumberOfNeededBits(int powerOfTwo) {
        int i = 0;
        int j;
        while ((j = powerOfTwo & 1 << i) == 0) {
            ++i;
        }
        return i;
    }

    private static int reverseBits(int index, int numberOfBits) {
        int ind = index;
        int rev = 0;
        for (int i = 0; i < numberOfBits; ++i) {
            rev = rev << 1 | ind & 1;
            ind >>= 1;
        }
        return rev;
    }

    private static int fastReverseBits(int index, int numberOfBits) {
        if (numberOfBits <= 16) {
            return FFT_BIT_TABLE[numberOfBits - 1][index];
        }
        return JavaFFT.reverseBits(index, numberOfBits);
    }

    private static boolean isPowerOfTwo(int number) {
        return (number & number - 1) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaFFT javaFFT = (JavaFFT)o;
        return this.numberOfSamples == javaFFT.numberOfSamples;
    }

    public int hashCode() {
        return this.numberOfSamples;
    }

    public String toString() {
        return "JavaFFT{N=" + this.numberOfSamples + "}";
    }

    static {
        int len = 2;
        for (int b = 1; b <= 16; ++b) {
            JavaFFT.FFT_BIT_TABLE[b - 1] = new int[len];
            for (int i = 0; i < len; ++i) {
                JavaFFT.FFT_BIT_TABLE[b - 1][i] = JavaFFT.reverseBits(i, b);
            }
            len <<= 1;
        }
    }
}

