/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.world;

import com.mentalfrostbyte.jello.event.impl.game.network.EventSendPacket;
import com.mentalfrostbyte.jello.event.impl.game.world.EventLoadWorld;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.system.math.counter.TimerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import team.sdhq.eventBus.annotations.EventTarget;

public class FakeLag
extends Module {
    public final List<IPacket<?>> packets = new ArrayList();
    public final TimerUtil timerUtil = new TimerUtil();
    public boolean isLagging;

    public FakeLag() {
        super(ModuleCategory.WORLD, "FakeLag", "Other players will see you lagging !");
        this.registerSetting((Setting)new NumberSetting("Lag duration", "The lags duration", 0.3f, 0.1f, 2.0f, 0.01f));
        this.registerSetting((Setting)new NumberSetting("Delay", "The lags cooldown", 0.4f, 0.1f, 2.0f, 0.01f));
        this.registerSetting((Setting)new BooleanSetting("Combat", "Delay combat packets", true));
        this.registerSetting((Setting)new BooleanSetting("Blocks", "Delay blocks packets", true));
        this.registerSetting((Setting)new BooleanSetting("Ping", "Delay ping packets", true));
        this.timerUtil.start();
    }

    @Override
    public void onEnable() {
        this.packets.clear();
        this.isLagging = false;
        this.timerUtil.reset();
    }

    @Override
    public void onDisable() {
        if (!this.packets.isEmpty() && FakeLag.mc.world != null) {
            for (IPacket<?> packet : this.packets) {
                mc.getConnection().getNetworkManager().sendPacket(packet);
            }
        }
    }

    @EventTarget
    public void onWorldLoad(EventLoadWorld event) {
        if (this.isEnabled()) {
            this.packets.clear();
            this.isLagging = false;
            this.timerUtil.reset();
        }
    }

    @EventTarget
    public void onSendPacket(EventSendPacket event) {
        if (!this.isEnabled() || mc.getConnection() == null) {
            return;
        }
        if (!this.isLagging) {
            if ((float)this.timerUtil.getElapsedTime() > this.getNumberValueBySettingName("Delay") * 1000.0f) {
                this.isLagging = true;
                this.timerUtil.reset();
            }
        } else if ((float)this.timerUtil.getElapsedTime() <= this.getNumberValueBySettingName("Lag duration") * 1000.0f) {
            IPacket<?> packet = event.packet;
            if (this.shouldDelayPacket(packet)) {
                this.packets.add(packet);
                event.cancelled = true;
            }
        } else {
            this.isLagging = false;
            this.timerUtil.reset();
            for (IPacket<?> packet : this.packets) {
                mc.getConnection().getNetworkManager().sendPacket(packet);
            }
            this.packets.clear();
        }
    }

    public boolean shouldDelayPacket(IPacket<?> packet) {
        if (packet instanceof CPlayerPacket) {
            return false;
        }
        if (packet instanceof CKeepAlivePacket || packet instanceof CConfirmTransactionPacket) {
            return this.getBooleanValueFromSettingName("Ping");
        }
        if (packet instanceof CUseEntityPacket || packet instanceof CAnimateHandPacket) {
            return this.getBooleanValueFromSettingName("Combat");
        }
        if (packet instanceof CPlayerTryUseItemPacket || packet instanceof CPlayerDiggingPacket || packet instanceof CPlayerTryUseItemOnBlockPacket) {
            return this.getBooleanValueFromSettingName("Blocks");
        }
        return false;
    }
}

