/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.render.jello;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.game.network.EventSendPacket;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender3D;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRenderNameTag;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.impl.player.Blink;
import com.mentalfrostbyte.jello.module.impl.render.Freecam;
import com.mentalfrostbyte.jello.module.impl.render.NameProtect;
import com.mentalfrostbyte.jello.module.impl.render.jello.esp.util.Class8781;
import com.mentalfrostbyte.jello.module.impl.render.jello.nametags.FurnaceTracker;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.client.render.Resources;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.player.PlayerUtil;
import com.mentalfrostbyte.jello.util.game.player.combat.CombatUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.world.PositionUtil;
import com.mentalfrostbyte.jello.util.game.world.blocks.BlockUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.FurnaceScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.FurnaceContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SWindowPropertyPacket;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import team.sdhq.eventBus.annotations.EventTarget;

public class NameTags
extends Module {
    public static final HashMap<String, Texture> field24003 = new HashMap();
    public int backgroundColor = RenderUtil.applyAlpha(RenderUtil.method17690(ClientColors.LIGHT_GREYISH_BLUE.getColor(), ClientColors.DEEP_TEAL.getColor(), 75.0f), 0.5f);
    public final HashMap<BlockPos, FurnaceTracker> furnaceTrackers = new HashMap();
    public BlockPos currentBlockPos;
    public final List<Entity> entities = new ArrayList<Entity>();
    public boolean trackFurnaces = false;
    public final HashMap<UUID, String> field24007 = new HashMap();

    public NameTags() {
        super(ModuleCategory.RENDER, "NameTags", "Render better name tags");
        this.registerSetting((Setting)new BooleanSetting("Magnify", "Scales nametags to keep them readable", true));
        this.registerSetting((Setting)new BooleanSetting("Furnaces", "Shows furnaces info once open", true));
        this.registerSetting((Setting)new BooleanSetting("Mob Owners", "Shows mob owners", true));
        this.setAvailableOnClassic(false);
    }

    @EventTarget
    public void onTick(EventUpdate event) {
        if (this.isEnabled()) {
            this.trackFurnaces = this.getBooleanValueFromSettingName("Furnaces");
            if (!this.trackFurnaces) {
                this.furnaceTrackers.clear();
            } else {
                Iterator<Map.Entry<BlockPos, FurnaceTracker>> iterator = this.furnaceTrackers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<BlockPos, FurnaceTracker> entry = iterator.next();
                    if (!(NameTags.mc.world.getBlockState(entry.getKey()).getBlock() instanceof FurnaceBlock)) {
                        iterator.remove();
                    }
                    entry.getValue().updateSmelting();
                }
            }
            this.entities.clear();
            for (Entity entity : BlockUtil.method34549(CombatUtil.getAllPlayersInWorld())) {
                if (entity == NameTags.mc.player || entity == Freecam.player || entity == Blink.clientPlayerEntity || entity.isInvisible() || Client.getInstance().botManager.isBot(entity)) continue;
                this.entities.add(entity);
            }
        }
    }

    @EventTarget
    public void onSendPacket(EventSendPacket event) {
        if (this.isEnabled()) {
            CPlayerTryUseItemOnBlockPacket var4;
            IPacket<?> iPacket = event.packet;
            if (iPacket instanceof CPlayerTryUseItemOnBlockPacket && NameTags.mc.world.getBlockState((var4 = (CPlayerTryUseItemOnBlockPacket)iPacket).func_218794_c().getPos()).getBlock() instanceof FurnaceBlock) {
                this.currentBlockPos = var4.func_218794_c().getPos();
            }
            if ((iPacket = event.packet) instanceof CClickWindowPacket) {
                CClickWindowPacket clickWindowPacket = (CClickWindowPacket)iPacket;
                FurnaceTracker var5 = this.getFurnaceTrackerByWindowId(clickWindowPacket.getWindowId());
                if (var5 == null) {
                    return;
                }
                Screen screen = NameTags.mc.currentScreen;
                if (screen instanceof FurnaceScreen) {
                    FurnaceScreen furnace = (FurnaceScreen)screen;
                    var5.inputStack = ((FurnaceContainer)furnace.getContainer()).getSlot(0).getStack();
                    var5.fuelStack = new ItemStack(((FurnaceContainer)furnace.getContainer()).getSlot(1).getStack().getItem());
                    var5.fuelStack.count = ((FurnaceContainer)furnace.getContainer()).getSlot((int)1).getStack().count;
                    var5.outputStack = ((FurnaceContainer)furnace.getContainer()).getSlot(2).getStack();
                }
            }
        }
    }

    @EventTarget
    public void onReceivePacket(EventReceivePacket event) {
        if (this.isEnabled()) {
            Object var5;
            IPacket<?> iPacket = event.packet;
            if (iPacket instanceof SOpenWindowPacket) {
                SOpenWindowPacket sOpenWindowPacket = (SOpenWindowPacket)iPacket;
                if (sOpenWindowPacket.getContainerType() != ContainerType.FURNACE) {
                    return;
                }
                this.furnaceTrackers.put(this.currentBlockPos, new FurnaceTracker(sOpenWindowPacket.getWindowId()));
            }
            if ((iPacket = event.packet) instanceof SSetSlotPacket) {
                SSetSlotPacket sSetSlotPacket = (SSetSlotPacket)iPacket;
                var5 = this.getFurnaceTrackerByWindowId(sSetSlotPacket.getWindowId());
                if (var5 == null) {
                    return;
                }
                if (sSetSlotPacket.getSlot() == 0) {
                    ((FurnaceTracker)var5).inputStack = new ItemStack(sSetSlotPacket.getStack().getItem());
                    ((FurnaceTracker)var5).inputStack.count = sSetSlotPacket.getStack().count;
                } else if (sSetSlotPacket.getSlot() == 1) {
                    ((FurnaceTracker)var5).fuelStack = new ItemStack(sSetSlotPacket.getStack().getItem());
                    ((FurnaceTracker)var5).fuelStack.count = sSetSlotPacket.getStack().count;
                } else if (sSetSlotPacket.getSlot() == 2) {
                    ((FurnaceTracker)var5).outputStack = new ItemStack(sSetSlotPacket.getStack().getItem());
                    ((FurnaceTracker)var5).outputStack.count = sSetSlotPacket.getStack().count;
                }
            }
            if ((var5 = event.packet) instanceof SWindowPropertyPacket) {
                SWindowPropertyPacket sWindowPropertyPacket = (SWindowPropertyPacket)var5;
                FurnaceTracker var8 = this.getFurnaceTrackerByWindowId(sWindowPropertyPacket.getWindowId());
                if (var8 == null) {
                    return;
                }
                switch (sWindowPropertyPacket.getProperty()) {
                    case 0: {
                        var8.smeltDelay = sWindowPropertyPacket.getValue();
                        break;
                    }
                    case 1: {
                        var8.cooldown = sWindowPropertyPacket.getValue();
                        break;
                    }
                    case 2: {
                        var8.smeltTime = sWindowPropertyPacket.getValue();
                        break;
                    }
                    case 3: {
                        var8.smeltProgress = sWindowPropertyPacket.getValue();
                    }
                }
            }
        }
    }

    public FurnaceTracker getFurnaceTrackerByWindowId(int windowId) {
        for (Map.Entry<BlockPos, FurnaceTracker> entry : this.furnaceTrackers.entrySet()) {
            if (entry.getValue().windowId != windowId) continue;
            return entry.getValue();
        }
        return null;
    }

    @EventTarget
    public void on3D(EventRender3D event) {
        if (this.isEnabled()) {
            float scale;
            RenderSystem.glMultiTexCoord2f(33986, 240.0f, 240.0f);
            boolean shouldMagnify = this.getBooleanValueFromSettingName("Magnify");
            for (Entity entity : this.entities) {
                scale = 1.0f;
                if (shouldMagnify) {
                    scale = (float)Math.max(1.0, Math.sqrt(PositionUtil.calculateDistanceSquared(entity) / 30.0));
                }
                this.drawNametag(PositionUtil.getEntityPosition((Entity)entity).x, PositionUtil.getEntityPosition((Entity)entity).y + (double)entity.getHeight(), PositionUtil.getEntityPosition((Entity)entity).z, entity, scale, null);
                entity.getDataManager().set(Entity.CUSTOM_NAME_VISIBLE, false);
            }
            for (Map.Entry entry : this.furnaceTrackers.entrySet()) {
                scale = 1.0f;
                if (shouldMagnify) {
                    scale = (float)Math.max((double)0.8f, Math.sqrt(PositionUtil.calculateDistanceSquared((BlockPos)entry.getKey()) / 30.0));
                }
                this.drawFurnaceNametag((BlockPos)entry.getKey(), (FurnaceTracker)entry.getValue(), scale);
            }
            if (this.getBooleanValueFromSettingName("Mob Owners")) {
                for (Entity entity : NameTags.mc.world.getAllEntities()) {
                    UUID uuid;
                    if (!(entity instanceof TameableEntity) && !(entity instanceof HorseEntity) || (uuid = entity instanceof TameableEntity ? ((TameableEntity)entity).getOwnerId() : ((HorseEntity)entity).getOwnerUniqueId()) == null) continue;
                    if (!this.field24007.containsKey(uuid)) {
                        this.field24007.put(uuid, null);
                        new Thread(() -> {
                            try {
                                List<String> var4x = PlayerUtil.getMobOwners(uuid.toString());
                                if (var4x == null || var4x.isEmpty()) {
                                    return;
                                }
                                this.field24007.put(uuid, var4x.get(var4x.size() - 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }).start();
                    }
                    if (this.field24007.get(uuid) == null) continue;
                    float scale2 = 1.0f;
                    if (this.getBooleanValueFromSettingName("Magnify")) {
                        scale2 = (float)Math.max(1.0, Math.sqrt(PositionUtil.calculateDistanceSquared(entity) / 30.0));
                    }
                    this.drawNametag(PositionUtil.getEntityPosition((Entity)entity).x, PositionUtil.getEntityPosition((Entity)entity).y + (double)entity.getHeight(), PositionUtil.getEntityPosition((Entity)entity).z, entity, scale2, this.field24007.get(uuid));
                    entity.getDataManager().set(Entity.CUSTOM_NAME_VISIBLE, false);
                }
            }
            GL11.glDisable((int)2896);
            RenderSystem.glMultiTexCoord2f(33986, 240.0f, 240.0f);
            mc.getTextureManager().bindTexture(TextureManager.RESOURCE_LOCATION_EMPTY);
        }
    }

    public void drawFurnaceNametag(BlockPos furnacePos, FurnaceTracker furnace, float partialTicks) {
        ItemStack itemStack;
        TrueTypeFont font = ResourceRegistry.JelloLightFont25;
        float renderX = (float)((double)furnacePos.getX() - NameTags.mc.gameRenderer.getActiveRenderInfo().getPos().getX() + 0.5);
        float renderY = (float)((double)furnacePos.getY() - NameTags.mc.gameRenderer.getActiveRenderInfo().getPos().getY() + 1.0);
        float renderZ = (float)((double)furnacePos.getZ() - NameTags.mc.gameRenderer.getActiveRenderInfo().getPos().getZ() + 0.5);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        float smeltingProgress = Math.min(furnace.smeltTime / furnace.smeltProgress, 1.0f);
        float cooldownProgress = Math.min((float)furnace.smeltDelay / (float)furnace.cooldown, 1.0f);
        int padding = 14;
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glTranslated((double)renderX, (double)(renderY + 0.6f - 0.33333334f * (1.0f - partialTicks)), (double)renderZ);
        GL11.glRotatef((float)NameTags.mc.gameRenderer.getActiveRenderInfo().getYaw(), (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)NameTags.mc.gameRenderer.getActiveRenderInfo().getPitch(), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        float scale = 0.008f;
        GL11.glScalef((float)(-scale * partialTicks), (float)(-scale * partialTicks), (float)(-scale * partialTicks));
        ItemStack outputItem = furnace.refreshOutput();
        int nameplateWidth = outputItem != null ? Math.max(ResourceRegistry.JelloLightFont20.getWidth(outputItem.getDisplayName().getString()), 50) : 37;
        int boxWidth = 51 + nameplateWidth + padding * 2;
        int boxHeight = 85 + padding * 2;
        GL11.glTranslated((double)(-boxWidth / 2), (double)(-boxHeight / 2), (double)0.0);
        RenderUtil.drawRect(0.0f, 0.0f, boxWidth, boxHeight, this.backgroundColor);
        RenderUtil.drawRoundedRect(0.0f, 0.0f, (float)boxWidth, (float)boxHeight, 20.0f, 0.5f);
        RenderUtil.drawString(font, padding, padding - 5, "Furnace", ClientColors.LIGHT_GREYISH_BLUE.getColor());
        if (outputItem == null) {
            RenderUtil.drawString(ResourceRegistry.JelloLightFont20, padding + 15, padding + 40, "Empty", RenderUtil.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.6f));
        }
        if ((itemStack = furnace.refreshOutput()) != null) {
            RenderUtil.drawItem(itemStack, padding, padding + 27, 45, 45);
            RenderUtil.drawString(ResourceRegistry.JelloLightFont20, padding + 51, 40.0f, itemStack.getDisplayName().getString(), ClientColors.LIGHT_GREYISH_BLUE.getColor());
            RenderUtil.drawString(ResourceRegistry.JelloLightFont14, padding + 51, 62.0f, "Count: " + itemStack.count, ClientColors.LIGHT_GREYISH_BLUE.getColor());
        }
        RenderUtil.drawRect(0.0f, (float)boxHeight - 12.0f, Math.min((float)boxWidth * cooldownProgress, (float)boxWidth), (float)boxHeight - 6.0f, RenderUtil.applyAlpha(-106750, 0.3f));
        RenderUtil.drawRect(0.0f, (float)boxHeight - 6.0f, Math.min((float)boxWidth * smeltingProgress, (float)boxWidth), boxHeight, RenderUtil.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.75f));
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2848);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
    }

    public void drawNametag(double x, double y, double z, Entity var7, float var8, String var9) {
        String var13;
        TrueTypeFont var12 = ResourceRegistry.JelloLightFont25;
        String string = var13 = var9 == null ? var7.getName().getString().replaceAll("\u00a7.", "") : var9;
        if (Client.getInstance().moduleManager.getModuleByClass(NameProtect.class).isEnabled() && var13.equals(mc.getSession().getUsername())) {
            var13 = Client.getInstance().moduleManager.getModuleByClass(NameProtect.class).getStringSettingValueByName("Username");
        }
        if (var13.length() == 0) {
            return;
        }
        float var14 = (float)(x - NameTags.mc.gameRenderer.getActiveRenderInfo().getPos().getX());
        float var15 = (float)(y - NameTags.mc.gameRenderer.getActiveRenderInfo().getPos().getY());
        float var16 = (float)(z - NameTags.mc.gameRenderer.getActiveRenderInfo().getPos().getZ());
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        String var17 = "" + (float)Math.round(((LivingEntity)var7).getHealth() * 10.0f) / 10.0f;
        float var18 = Math.min(((LivingEntity)var7).getHealth() / ((LivingEntity)var7).getMaxHealth(), 1.0f);
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)519, (float)0.0f);
        GL11.glTranslated((double)var14, (double)(var15 + 0.6f - 0.33333334f * (1.0f - var8)), (double)var16);
        GL11.glRotatef((float)NameTags.mc.gameRenderer.getActiveRenderInfo().getYaw(), (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)NameTags.mc.gameRenderer.getActiveRenderInfo().getPitch(), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-0.009f * var8), (float)(-0.009f * var8), (float)(-0.009f * var8));
        int var19 = this.backgroundColor;
        if (!Client.getInstance().friendManager.isFriendPure(var7)) {
            if (Client.getInstance().friendManager.isFriend(var7)) {
                var19 = RenderUtil.applyAlpha(-6750208, 0.5f);
            }
        } else {
            var19 = RenderUtil.applyAlpha(-16171506, 0.5f);
        }
        int var20 = RenderUtil.applyAlpha(!(var7 instanceof PlayerEntity) ? ClientColors.LIGHT_GREYISH_BLUE.getColor() : new Color(Class8781.method31663((PlayerEntity)var7)).getRGB(), 0.5f);
        int var21 = var12.getWidth(var13) / 2;
        if (!field24003.containsKey(var13)) {
            RenderUtil.drawRoundedRect((float)(-var21 - 10), -25.0f, (float)(var21 * 2 + 20), (float)(var12.getHeight() + 27), 20.0f, 0.5f);
        } else {
            int var22 = Color.getHSBColor((float)(System.currentTimeMillis() % 10000L) / 10000.0f, 0.5f, 1.0f).getRGB();
            RenderUtil.drawImage((float)(-var21 - 10 - 31), -25.0f, (float)(var12.getHeight() + 27), (float)(var12.getHeight() + 27), field24003.get(var13), RenderUtil.applyAlpha(var22, 0.7f));
            RenderUtil.drawImage((float)(-var21 - 10 - 31 + var12.getHeight() + 27), -25.0f, 14.0f, (float)(var12.getHeight() + 27), Resources.shadowRightPNG, RenderUtil.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.6f));
            RenderUtil.drawRoundedRect((float)(-var21 - 10 - 31), -25.0f, (float)(var21 * 2 + 20 + 31 + 27), (float)(var12.getHeight() + 27), 20.0f, 0.5f);
            GL11.glTranslatef((float)27.0f, (float)0.0f, (float)0.0f);
        }
        RenderUtil.drawRect(-var21 - 10, -25.0f, var21 + 10, var12.getHeight() + 2, var19);
        RenderUtil.drawRect(-var21 - 10, (float)(var12.getHeight() - 1) - (float)((LivingEntity)var7).hurtTime / 3.0f, Math.min((float)(var21 * 2 + 20) * (var18 - 0.5f), (float)(var21 + 10)), var12.getHeight() + 2, var20);
        GL11.glTranslated((double)(-var12.getWidth(var13) / 2), (double)0.0, (double)0.0);
        int var26 = ResourceRegistry.JelloLightFont14.getWidth("Health: 20.0");
        String var23 = "Health: ";
        int var24 = var12.getWidth(var13);
        if (var26 > var24) {
            var23 = "H: ";
        }
        RenderUtil.drawString(var12, 0.0f, -20.0f, var13, ClientColors.LIGHT_GREYISH_BLUE.getColor());
        RenderUtil.drawString(ResourceRegistry.JelloLightFont14, 0.0f, 10.0f, var23 + var17, ClientColors.LIGHT_GREYISH_BLUE.getColor());
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2848);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
    }

    @EventTarget
    public void method16934(EventRenderNameTag event) {
        if (this.isEnabled() && event.getEntity() instanceof PlayerEntity) {
            event.cancelled = true;
        }
    }

    static {
        field24003.put("Tomygaims", Resources.tomyPNG);
        field24003.put("Andro24", Resources.androPNG);
        field24003.put("Gretorm", Resources.lpPNG);
        field24003.put("Flyinqq", Resources.codyPNG);
        field24003.put("cxbot", Resources.cxPNG);
    }
}

