/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.render;

import com.mentalfrostbyte.jello.event.impl.game.render.EventRender3D;
import com.mentalfrostbyte.jello.event.impl.game.world.EventLoadWorld;
import com.mentalfrostbyte.jello.event.impl.player.movement.EventMove;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ColorSetting;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.annotations.EventTarget;

public class Breadcrumbs
extends Module {
    private final List<Vector3d> breadcrumbsPath = new ArrayList<Vector3d>();

    public Breadcrumbs() {
        super(ModuleCategory.RENDER, "Breadcrumbs", "Shows your taken path");
        this.registerSetting((Setting)new BooleanSetting("Fade Out", "Makes distant breadcrumbs fade out", true));
        this.registerSetting((Setting)new ColorSetting("Color", "The crumbs color", ClientColors.LIGHT_GREYISH_BLUE.getColor()));
    }

    @EventTarget
    public void onMove(EventMove event) {
        if (event.getX() != 0.0 || event.getY() != 0.0 || event.getZ() != 0.0) {
            this.breadcrumbsPath.add(new Vector3d(Breadcrumbs.mc.player.getPosX(), Breadcrumbs.mc.player.getPosY(), Breadcrumbs.mc.player.getPosZ()));
        }
    }

    @EventTarget
    public void onWorldLoad(EventLoadWorld event) {
        this.breadcrumbsPath.clear();
    }

    @Override
    public void onDisable() {
        this.breadcrumbsPath.clear();
    }

    public Vector3d adjustForRendering(Vector3d position) {
        return position.add(new Vector3d(-Minecraft.getInstance().gameRenderer.getActiveRenderInfo().getPos().getX(), -Minecraft.getInstance().gameRenderer.getActiveRenderInfo().getPos().getY(), -Minecraft.getInstance().gameRenderer.getActiveRenderInfo().getPos().getZ()));
    }

    @EventTarget
    public void onRender3D(EventRender3D event) {
        Vector3d interpolatedPlayerPosition = new Vector3d(Breadcrumbs.mc.player.lastTickPosX - (Breadcrumbs.mc.player.lastTickPosX - Breadcrumbs.mc.player.getPosX()) * (double)mc.getRenderPartialTicks(), Breadcrumbs.mc.player.lastTickPosY - (Breadcrumbs.mc.player.lastTickPosY - Breadcrumbs.mc.player.getPosY()) * (double)mc.getRenderPartialTicks(), Breadcrumbs.mc.player.lastTickPosZ - (Breadcrumbs.mc.player.lastTickPosZ - Breadcrumbs.mc.player.getPosZ()) * (double)mc.getRenderPartialTicks());
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4fv((float[])RenderUtil.method17709(RenderUtil.applyAlpha(this.parseSettingValueToIntBySettingName("Color"), 0.5f)));
        GL11.glBegin((int)3);
        for (Vector3d breadcrumb : this.breadcrumbsPath) {
            double fadeFactor;
            Vector3d adjustedBreadcrumb = this.adjustForRendering(breadcrumb);
            double distance = breadcrumb.distanceTo(interpolatedPlayerPosition);
            double d = fadeFactor = !this.getBooleanValueFromSettingName("Fade Out") ? (double)0.6f : 1.0 - Math.min(1.0, distance / 14.0);
            if (distance > 24.0) continue;
            GL11.glColor4fv((float[])RenderUtil.method17709(RenderUtil.applyAlpha(this.parseSettingValueToIntBySettingName("Color"), (float)fadeFactor)));
            GL11.glVertex3d((double)adjustedBreadcrumb.x, (double)adjustedBreadcrumb.y, (double)adjustedBreadcrumb.z);
        }
        Vector3d adjustedPlayerPosition = this.adjustForRendering(interpolatedPlayerPosition);
        GL11.glVertex3d((double)adjustedPlayerPosition.x, (double)adjustedPlayerPosition.y, (double)adjustedPlayerPosition.z);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2848);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }
}

