/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.movement.fly;

import com.mentalfrostbyte.jello.event.impl.game.action.EventKeyPress;
import com.mentalfrostbyte.jello.event.impl.game.action.EventMouseHover;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2D;
import com.mentalfrostbyte.jello.event.impl.player.movement.EventMotion;
import com.mentalfrostbyte.jello.event.impl.player.movement.EventMove;
import com.mentalfrostbyte.jello.gui.base.JelloPortal;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.game.player.MovementUtil;
import com.mentalfrostbyte.jello.util.game.world.blocks.BlockUtil;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import team.sdhq.eventBus.annotations.EventTarget;

public class VClipFly
extends Module {
    private final BooleanSetting hideMotion;
    private final NumberSetting<Float> speed = new NumberSetting("Speed", "Fly speed", 4.0f, 0.28f, 10.0f, 0.01f);
    private boolean sneakCancelled;
    private int ticksInAir;
    public int ticksSinceLastVClip;
    private double previousY;
    private final NumberSetting<Float> minFallDistance;
    private final ModeSetting clipDistanceMode;
    private final ModeSetting whenToClip;
    private final NumberSetting<Float> delay;
    private final NumberSetting<Float> constantClipDistance;

    public VClipFly() {
        super(ModuleCategory.MOVEMENT, "VClip", "Fly that uses VClip");
        this.registerSetting((Setting)this.speed);
        this.whenToClip = new ModeSetting("When", "When do we VClip?", "Fall distance", "Fall distance", "Time");
        this.registerSetting((Setting)this.whenToClip);
        this.delay = new NumberSetting("Delay", "Delay", 3.0f, 0.1f, 10.0f, 0.1f);
        this.registerSetting((Setting)this.delay);
        this.minFallDistance = new NumberSetting("Fall distance", "Minimum fall distance before we VClip back up", 1.0f, 0.3f, 25.5f, 0.1f);
        this.registerSetting((Setting)this.minFallDistance);
        this.clipDistanceMode = new ModeSetting("Clip distance mode", "Minimum fall distance before we VClip back up", "Fall distance", "Fall distance", "Constant");
        this.registerSetting((Setting)this.clipDistanceMode);
        this.constantClipDistance = new NumberSetting("Clip distance (if constant)", "Blocks to clip up after falling the minimum distance", 1.0f, 0.1f, 25.5f, 0.001f);
        this.registerSetting((Setting)this.constantClipDistance);
        this.registerSetting((Setting)new BooleanSetting("Kick bypass", "Bypass vanilla kick for flying", true));
        this.hideMotion = new BooleanSetting("Fake", "Hides the horrible constant clipping, disable if you want a seizure", true);
        this.registerSetting((Setting)this.hideMotion);
    }

    @Override
    public void onEnable() {
        if (!VClipFly.mc.gameSettings.keyBindSneak.isKeyDown()) {
            this.sneakCancelled = false;
        } else {
            VClipFly.mc.gameSettings.keyBindSneak.setPressed(false);
            this.sneakCancelled = true;
        }
        this.previousY = VClipFly.mc.player.getPosY();
    }

    @Override
    public void onDisable() {
        VClipFly.mc.player.setMotion(VClipFly.mc.player.getMotion().x, -0.08, VClipFly.mc.player.getMotion().z);
        double plrSpeed = MovementUtil.getSmartSpeed();
        MovementUtil.moveInDirection(plrSpeed);
        if (this.sneakCancelled) {
            VClipFly.mc.gameSettings.keyBindSneak.setPressed(true);
        }
    }

    @EventTarget
    public void onKeyPress(EventKeyPress event) {
        if (this.isEnabled() && event.getKey() == VClipFly.mc.gameSettings.keyBindSneak.keyCode.getKeyCode()) {
            event.cancelled = true;
            this.sneakCancelled = true;
        }
    }

    @EventTarget
    public void onMouseHover(EventMouseHover event) {
        if (this.isEnabled() && event.getMouseButton() == VClipFly.mc.gameSettings.keyBindSneak.keyCode.getKeyCode()) {
            event.cancelled = true;
            this.sneakCancelled = false;
        }
    }

    @EventTarget
    public void onRender(EventRender2D __) {
        if (!((Boolean)this.hideMotion.currentValue).booleanValue()) {
            return;
        }
        double newY = this.previousY + this.getVerticalSpeed();
        VClipFly.mc.player.setPosition(VClipFly.mc.player.getPosX(), newY, VClipFly.mc.player.getPosZ());
        VClipFly.mc.player.lastTickPosY = newY;
        VClipFly.mc.player.chasingPosY = newY;
        VClipFly.mc.player.prevPosY = newY;
    }

    @EventTarget
    public void onUpdate(EventMotion event) {
        if (!this.isEnabled()) {
            return;
        }
        if (VClipFly.mc.player.isOnGround()) {
            return;
        }
        if (!this.getBooleanValueFromSettingName("Kick bypass")) {
            return;
        }
        if (this.ticksInAir > 0 && this.ticksInAir % 30 == 0 && !BlockUtil.isAboveBounds(VClipFly.mc.player, 0.01f)) {
            if (!JelloPortal.getVersion().equalTo(ProtocolVersion.v1_8)) {
                event.setY(event.getY() - 0.04);
            } else {
                double collisionHeight = this.getGroundCollisionHeight();
                if (collisionHeight < 0.0) {
                    return;
                }
                double yPosition = event.getY();
                ArrayList<Double> yPositions = new ArrayList<Double>();
                if (!(yPosition - collisionHeight > 9.0)) {
                    mc.getConnection().sendPacket(new CPlayerPacket.PositionPacket(event.getX(), collisionHeight, event.getZ(), true));
                } else {
                    while (yPosition > collisionHeight + 9.0) {
                        yPositions.add(yPosition -= 9.0);
                        mc.getConnection().sendPacket(new CPlayerPacket.PositionPacket(event.getX(), yPosition, event.getZ(), true));
                    }
                    for (Double intermediateY : yPositions) {
                        mc.getConnection().sendPacket(new CPlayerPacket.PositionPacket(event.getX(), intermediateY, event.getZ(), true));
                    }
                    mc.getConnection().sendPacket(new CPlayerPacket.PositionPacket(event.getX(), collisionHeight, event.getZ(), true));
                    Collections.reverse(yPositions);
                    for (Double intermediateYReversed : yPositions) {
                        mc.getConnection().sendPacket(new CPlayerPacket.PositionPacket(event.getX(), intermediateYReversed, event.getZ(), true));
                    }
                    mc.getConnection().sendPacket(new CPlayerPacket.PositionPacket(event.getX(), event.getY(), event.getZ(), true));
                }
                this.ticksInAir = 0;
            }
        }
    }

    double getVerticalSpeed() {
        double verticalSpeed;
        double d = verticalSpeed = !VClipFly.mc.gameSettings.keyBindJump.isPressed() ? 0.0 : (double)((Float)this.speed.currentValue).floatValue() / 2.0;
        if (VClipFly.mc.gameSettings.keyBindJump.isPressed() && VClipFly.mc.gameSettings.keyBindSneak.isPressed()) {
            verticalSpeed = 0.0;
        } else if (!this.sneakCancelled) {
            if (VClipFly.mc.gameSettings.keyBindJump.isPressed()) {
                verticalSpeed = (double)((Float)this.speed.currentValue).floatValue() / 2.0;
            }
        } else {
            verticalSpeed = (double)(-((Float)this.speed.currentValue).floatValue()) / 2.0;
        }
        return verticalSpeed;
    }

    private void doVClip(double fallDistance) {
        double clipY;
        double d = clipY = Objects.equals(this.clipDistanceMode.currentValue, "Constant") ? (double)((Float)this.constantClipDistance.currentValue).floatValue() : fallDistance;
        assert (VClipFly.mc.player != null);
        double newY = VClipFly.mc.player.getPosY() + clipY + this.getVerticalSpeed();
        Objects.requireNonNull(mc.getConnection()).handlePlayerPosLook(new SPlayerPositionLookPacket(VClipFly.mc.player.getPosX(), newY, VClipFly.mc.player.getPosZ(), VClipFly.mc.player.rotationYaw, VClipFly.mc.player.rotationPitch, Collections.emptySet(), (int)(2.147483647E9 * Math.random())));
        this.previousY = newY;
    }

    @EventTarget
    public void onMove(EventMove event) {
        if (this.isEnabled()) {
            this.ticksInAir = !BlockUtil.isAboveBounds(VClipFly.mc.player, 0.01f) ? ++this.ticksInAir : 0;
            double speed = this.getNumberValueBySettingName("Speed");
            double verticalSpeed = this.getVerticalSpeed();
            MovementUtil.setMotion(event, speed);
            double fallDistance = VClipFly.mc.player.getPosY() - this.previousY;
            if (fallDistance < 0.0) {
                fallDistance = -fallDistance;
            }
            switch ((String)this.whenToClip.currentValue) {
                case "Fall distance": {
                    if (!(fallDistance > (double)((Float)this.minFallDistance.currentValue).floatValue()) || VClipFly.mc.player.isOnGround()) break;
                    this.doVClip(fallDistance);
                    break;
                }
                case "Time": {
                    ++this.ticksSinceLastVClip;
                    if (!((float)this.ticksSinceLastVClip >= ((Float)this.delay.currentValue).floatValue())) break;
                    this.doVClip(fallDistance);
                    this.ticksSinceLastVClip = 0;
                }
            }
        }
    }

    private double getGroundCollisionHeight() {
        if (!(VClipFly.mc.player.getPositionVec().y < 1.0)) {
            if (!VClipFly.mc.player.isOnGround()) {
                AxisAlignedBB alignedBB = VClipFly.mc.player.getBoundingBox().expand(0.0, -VClipFly.mc.player.getPositionVec().y, 0.0);
                Iterator shapeIterator = VClipFly.mc.world.getCollisionShapes(VClipFly.mc.player, alignedBB).iterator();
                double maxCollisionHeight = -1.0;
                while (shapeIterator.hasNext()) {
                    VoxelShape voxelShape = (VoxelShape)shapeIterator.next();
                    if (!(voxelShape.getBoundingBox().maxY > maxCollisionHeight)) continue;
                    maxCollisionHeight = voxelShape.getBoundingBox().maxY;
                }
                return maxCollisionHeight;
            }
            return VClipFly.mc.player.getPosY();
        }
        return -1.0;
    }
}

