/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.misc.gameplay.miniblox;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.world.EventLoadWorld;
import com.mentalfrostbyte.jello.event.impl.player.LivingDeathEvent;
import com.mentalfrostbyte.jello.event.impl.player.movement.EventMotion;
import com.mentalfrostbyte.jello.managers.util.notifs.Notification;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class AutoBuy {
    public static boolean wasBuying;
    public static final BooleanSetting sword;
    public static final BooleanSetting stoneSword;
    public static final BooleanSetting ironSword;
    public static final BooleanSetting diamondSword;
    public static final BooleanSetting armor;
    public static final BooleanSetting chainmailArmor;
    public static final BooleanSetting ironArmor;
    public static final BooleanSetting diamondArmor;
    public static final BooleanSetting doUpgrades;
    public static final BooleanSetting sharpnessUpgrade;
    public static final BooleanSetting protectionUpgrade;
    public static final BooleanSetting hasteUpgrade;
    public static final BooleanSetting healPoolUpgrade;
    public static final BooleanSetting forgeUpgrade;
    public static final List<ShopItemMeta> allSwordItems;
    public static final List<ShopItemMeta> allArmorItems;
    public static final List<ShopItemMeta> swordItems;
    public static final List<ShopItemMeta> armorItems;
    public static final List<ShopUpgradeMeta> allUpgrades;
    public static final List<ShopUpgradeMeta> upgrades;

    static void runCommand(String command) {
        assert (MinecraftUtil.mc.player != null);
        MinecraftUtil.mc.player.sendChatMessage("/" + command);
    }

    static void handleShopItems(List<ShopItemMeta> items) {
        for (ShopItemMeta shopItemMeta : items) {
            if (shopItemMeta.shouldBuy() && !wasBuying) {
                ResourceLocation resourceLocation = Registry.ITEM.getKey((Item)shopItemMeta.item);
                String itemName = resourceLocation.getPath();
                wasBuying = true;
                Client.getInstance().notificationManager.send(new Notification("AutoBuy", "Buying " + itemName, 5000));
                AutoBuy.runCommand("buy " + itemName);
                items.remove(shopItemMeta);
            }
            wasBuying = false;
        }
    }

    static void resetState(boolean resetUpgrades) {
        wasBuying = false;
        swordItems.clear();
        armorItems.clear();
        if (resetUpgrades) {
            upgrades.clear();
        }
        swordItems.addAll(allSwordItems);
        armorItems.addAll(allArmorItems);
        if (resetUpgrades) {
            upgrades.addAll(allUpgrades);
        }
    }

    public static void onWorldEvent(EventLoadWorld __) {
        AutoBuy.resetState(true);
    }

    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getEntity() == MinecraftUtil.mc.player) {
            AutoBuy.resetState(false);
        }
    }

    public static void onUpdateEvent(EventMotion __) {
        if (MinecraftUtil.mc.player == null || MinecraftUtil.mc.world == null) {
            return;
        }
        if (((Boolean)AutoBuy.sword.currentValue).booleanValue()) {
            AutoBuy.handleShopItems(swordItems);
        }
        if (((Boolean)AutoBuy.armor.currentValue).booleanValue()) {
            AutoBuy.handleShopItems(armorItems);
        }
        if (((Boolean)AutoBuy.doUpgrades.currentValue).booleanValue()) {
            for (ShopUpgradeMeta upgrade : upgrades) {
                if (!upgrade.shouldBuy()) continue;
                Client.getInstance().notificationManager.send(new Notification("AutoBuy", "Upgrading " + (String)upgrade.item));
                AutoBuy.runCommand("upgrade " + (String)upgrade.item);
                if (upgrade.nextCost()) continue;
                System.out.println("The upgrade " + (String)upgrade.item + " has been maxed out.");
                upgrades.remove(upgrade);
                break;
            }
        }
    }

    public static boolean hasItem(Item item) {
        for (ItemStack stack : MinecraftUtil.mc.player.inventory.mainInventory) {
            if (stack == null || stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static int countItem(Item item) {
        int count = 0;
        assert (MinecraftUtil.mc.player != null);
        for (ItemStack stack : MinecraftUtil.mc.player.inventory.mainInventory) {
            if (stack == null || stack.getItem() != item) continue;
            count += stack.getMaxStackSize();
        }
        return count;
    }

    static {
        sword = new BooleanSetting("Sword", "Buy & Upgrade swords?", true);
        stoneSword = new BooleanSetting("Stone Sword", "Stone", false);
        ironSword = new BooleanSetting("Iron Sword", "Iron", true);
        diamondSword = new BooleanSetting("Diamond Sword", "Diamond", true);
        armor = new BooleanSetting("Armor", "Buy & Upgrade armor?", true);
        chainmailArmor = new BooleanSetting("Chainmail Armor", "", false);
        ironArmor = new BooleanSetting("Iron Armor", "", true);
        diamondArmor = new BooleanSetting("Diamond Armor", "", true);
        doUpgrades = new BooleanSetting("Upgrades", "Buy upgrades?", true);
        sharpnessUpgrade = new BooleanSetting("Sharpness", "", true);
        protectionUpgrade = new BooleanSetting("Protection", "", true);
        hasteUpgrade = new BooleanSetting("Haste", "", true);
        healPoolUpgrade = new BooleanSetting("Heal Pool", "", true);
        forgeUpgrade = new BooleanSetting("Forge", "", true);
        allSwordItems = new ArrayList<ShopItemMeta>();
        allArmorItems = new ArrayList<ShopItemMeta>();
        swordItems = new ArrayList<ShopItemMeta>();
        armorItems = new ArrayList<ShopItemMeta>();
        allUpgrades = new ArrayList<ShopUpgradeMeta>();
        upgrades = new ArrayList<ShopUpgradeMeta>();
        allSwordItems.add(new ShopItemMeta(Items.STONE_SWORD, 10, Items.IRON_INGOT, stoneSword));
        allSwordItems.add(new ShopItemMeta(Items.IRON_SWORD, 7, Items.GOLD_INGOT, ironSword));
        allSwordItems.add(new ShopItemMeta(Items.DIAMOND_SWORD, 4, Items.EMERALD, diamondSword));
        allArmorItems.add(new ShopItemMeta(Items.CHAINMAIL_CHESTPLATE, 24, Items.IRON_INGOT, chainmailArmor));
        allArmorItems.add(new ShopItemMeta(Items.IRON_CHESTPLATE, 12, Items.GOLD_INGOT, ironArmor));
        allArmorItems.add(new ShopItemMeta(Items.DIAMOND_CHESTPLATE, 6, Items.EMERALD, diamondArmor));
        allSwordItems.sort(ShopItemMeta::compareTo);
        allArmorItems.sort(ShopItemMeta::compareTo);
        swordItems.addAll(allSwordItems);
        armorItems.addAll(allArmorItems);
        int[] _4816 = new int[]{4, 8, 16};
        allUpgrades.add(new ShopUpgradeMeta("sharpness", _4816, sharpnessUpgrade));
        allUpgrades.add(new ShopUpgradeMeta("protection", _4816, protectionUpgrade));
        allUpgrades.add(new ShopUpgradeMeta("haste", new int[]{2, 4}, hasteUpgrade));
        allUpgrades.add(new ShopUpgradeMeta("healPool", 1, healPoolUpgrade));
        allUpgrades.add(new ShopUpgradeMeta("forge", new int[]{2, 4, 6, 8}, forgeUpgrade));
        upgrades.addAll(allUpgrades);
    }

    public static class ShopItemMeta
    extends PaidItem<Item>
    implements Comparable<ShopItemMeta> {
        ShopItemMeta(Item item, int cost, Item currency) {
            this.item = item;
            this.cost = cost;
            this.currency = currency;
        }

        ShopItemMeta(Item item, int cost, Item currency, BooleanSetting relatedSetting) {
            this.item = item;
            this.cost = cost;
            this.currency = currency;
            this.relatedSetting = relatedSetting;
        }

        public float getDefaultToolScore(ToolItem tool) {
            float score;
            String name = tool.getTranslationKey().toLowerCase();
            ItemStack stack = new ItemStack(tool, 1);
            if (tool instanceof PickaxeItem) {
                score = tool.getDestroySpeed(stack, Blocks.STONE.getDefaultState()) - (float)(name.contains("gold") ? 5 : 0);
            } else if (tool instanceof ShovelItem) {
                score = tool.getDestroySpeed(stack, Blocks.DIRT.getDefaultState()) - (float)(name.contains("gold") ? 5 : 0);
            } else {
                if (!(tool instanceof AxeItem)) {
                    return 1.0f;
                }
                score = tool.getDestroySpeed(stack, Blocks.OAK_LOG.getDefaultState()) - (float)(name.contains("gold") ? 5 : 0);
            }
            return score;
        }

        @Override
        public boolean shouldBuy() {
            return this.canBuy() && !AutoBuy.hasItem((Item)this.item) && this.relatedSetting != null && (Boolean)this.relatedSetting.currentValue != false;
        }

        @Override
        public int compareTo(ShopItemMeta o) {
            Object damage12;
            Object reduce12;
            Object object = o.item;
            if (object instanceof ArmorItem) {
                ArmorItem armor2 = (ArmorItem)object;
                object = this.item;
                if (object instanceof ArmorItem) {
                    float reduce2;
                    ArmorItem armor1 = (ArmorItem)object;
                    float reduce12 = armor1.getDamageReduceAmount();
                    if (reduce12 == (reduce2 = (float)armor2.getDamageReduceAmount())) {
                        return 0;
                    }
                    return reduce12 < reduce2 ? -1 : 1;
                }
            }
            if ((reduce12 = o.item) instanceof SwordItem) {
                SwordItem sword2 = (SwordItem)reduce12;
                reduce12 = this.item;
                if (reduce12 instanceof SwordItem) {
                    float damage2;
                    SwordItem sword1 = (SwordItem)reduce12;
                    float damage12 = sword1.getAttackDamage();
                    if (damage12 == (damage2 = sword2.getAttackDamage())) {
                        return 0;
                    }
                    return damage12 < damage2 ? -1 : 1;
                }
            }
            if ((damage12 = o.item) instanceof ToolItem) {
                ToolItem tool2 = (ToolItem)damage12;
                damage12 = this.item;
                if (damage12 instanceof ToolItem) {
                    float tool2Score;
                    ToolItem tool1 = (ToolItem)damage12;
                    float tool1Score = this.getDefaultToolScore(tool1);
                    if (tool1Score == (tool2Score = this.getDefaultToolScore(tool2))) {
                        return 0;
                    }
                    return tool1Score < tool2Score ? -1 : 1;
                }
            }
            throw new ClassCastException("Can't compare " + String.valueOf(((Item)this.item).getClass()) + " and " + String.valueOf(((Item)o.item).getClass()));
        }
    }

    public static class ShopUpgradeMeta
    extends PaidItem<String> {
        int[] costs;
        int currentCostIndex = 0;

        ShopUpgradeMeta(String item, int cost, Item currency) {
            this(item, new int[]{cost}, currency);
        }

        ShopUpgradeMeta(String item, int[] costs, Item currency) {
            this.item = item;
            this.costs = costs;
            this.cost = costs[0];
            this.currency = currency;
        }

        ShopUpgradeMeta(String item, int[] costs) {
            this(item, costs, Items.DIAMOND);
        }

        ShopUpgradeMeta(String item, int cost, BooleanSetting relatedSetting) {
            this(item, cost, Items.DIAMOND);
            this.relatedSetting = relatedSetting;
        }

        ShopUpgradeMeta(String item, int[] costs, BooleanSetting relatedSetting) {
            this(item, costs);
            this.relatedSetting = relatedSetting;
        }

        boolean nextCost() {
            ++this.currentCostIndex;
            if (this.currentCostIndex < this.costs.length - 1 || this.currentCostIndex >= this.costs.length - 1) {
                return false;
            }
            this.cost = this.costs[this.currentCostIndex];
            return true;
        }

        @Override
        public boolean shouldBuy() {
            return this.canBuy() && this.relatedSetting != null && (Boolean)this.relatedSetting.currentValue != false;
        }
    }

    public static abstract class PaidItem<T> {
        T item;
        int cost = 0;
        Item currency = null;
        @Nullable
        BooleanSetting relatedSetting;

        public boolean canBuy() {
            return AutoBuy.countItem(this.currency) >= this.cost;
        }

        public abstract boolean shouldBuy();
    }
}

