/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.misc;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.game.network.EventSendPacket;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.network.IPacket;
import org.apache.commons.lang3.reflect.FieldUtils;
import team.sdhq.eventBus.annotations.EventTarget;

public class PacketDumper
extends Module {
    public FileWriter packetWriter;

    public PacketDumper() {
        super(ModuleCategory.MISC, "Packet dumper", "Dumps packets sent to and fro from the client and server");
        try {
            File packetLog = new File(String.valueOf(Client.getInstance().file) + "/latest_packets.txt");
            if (!packetLog.exists()) {
                packetLog.createNewFile();
            }
            this.packetWriter = new FileWriter(packetLog);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String extractFieldValue(Field field, Object packetInstance) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        if (field.getType() == Integer.TYPE) {
            return Integer.toString(field.getInt(packetInstance));
        }
        if (field.getType() == Boolean.TYPE) {
            return Boolean.toString(field.getBoolean(packetInstance));
        }
        if (field.getType() == Float.TYPE) {
            return Float.toString(field.getFloat(packetInstance));
        }
        if (field.getType() == Double.TYPE) {
            return Double.toString(field.getDouble(packetInstance));
        }
        if (field.getType() == Long.TYPE) {
            return Long.toString(field.getLong(packetInstance));
        }
        if (field.getType() == Character.TYPE) {
            return Character.toString(field.getChar(packetInstance));
        }
        if (field.getType() == Byte.TYPE) {
            return Byte.toString(field.getByte(packetInstance));
        }
        if (field.getType() == Short.TYPE) {
            return Short.toString(field.getShort(packetInstance));
        }
        return field.get(packetInstance) != null ? field.get(packetInstance).toString() : "null";
    }

    private void logPacket(IPacket packet, boolean isSent) {
        try {
            this.packetWriter.write((isSent ? "-->" : "<--") + "\t" + packet.getClass().getSimpleName() + "\n");
            for (Field field : FieldUtils.getAllFields(packet.getClass())) {
                try {
                    this.packetWriter.write("\t\t" + field.getName() + "=" + this.extractFieldValue(field, packet) + "\n");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @EventTarget
    public void onPacketSend(EventSendPacket event) {
        if (this.isEnabled()) {
            this.logPacket(event.packet, true);
        }
    }

    @EventTarget
    public void onPacketReceive(EventReceivePacket event) {
        if (this.isEnabled()) {
            this.logPacket(event.packet, false);
        }
    }
}

