/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.misc;

import com.mentalfrostbyte.jello.event.impl.game.network.EventReceivePacket;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mojang.datafixers.util.Pair;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import team.sdhq.eventBus.annotations.EventTarget;

public class Murderer
extends Module {
    public String murdererSkinName = "IBreakerman";
    private Texture murdererSkinHead;
    private boolean initialisedTexture = true;
    private boolean foundMurderer;

    public Murderer() {
        super(ModuleCategory.MISC, "Murderer", "Detects murderer in murder mystery minigame on hypixel");
        this.registerSetting((Setting)new BooleanSetting("GUI", "Shows a GUI with info on the murderer", true));
        this.registerSetting((Setting)new BooleanSetting("Chat Message", "Sends a message with the murderer's name", true));
    }

    @EventTarget
    public void onReceive(EventReceivePacket event) {
        IPacket<?> iPacket = event.packet;
        if (iPacket instanceof SEntityEquipmentPacket) {
            SEntityEquipmentPacket entityEquipmentPacket = (SEntityEquipmentPacket)iPacket;
            for (Pair pair : entityEquipmentPacket.func_241790_c_()) {
                if (pair.getSecond() == null || !(((ItemStack)pair.getSecond()).getItem() instanceof SwordItem) || !(Murderer.mc.world.getEntityByID(entityEquipmentPacket.getEntityID()) instanceof PlayerEntity)) continue;
                Entity entity = Murderer.mc.world.getEntityByID(entityEquipmentPacket.getEntityID());
                if (!this.murdererSkinName.equalsIgnoreCase(entity.getName().getString())) {
                    if (this.getBooleanValueFromSettingName("Chat Message")) {
                        // empty if block
                    }
                    this.murdererSkinName = entity.getName().getUnformattedComponentText();
                    new Thread(() -> this.loadMurdererSkinHead(entity.getUniqueID().toString().replaceAll("-", ""))).start();
                    this.initialisedTexture = true;
                    this.foundMurderer = true;
                }
                this.murdererSkinName = entity.getName().getUnformattedComponentText();
            }
        }
        if (event.packet instanceof SRespawnPacket) {
            this.foundMurderer = false;
        }
    }

    @EventTarget
    public void onRender(EventRender2DOffset event) {
        if (this.foundMurderer && this.getBooleanValueFromSettingName("GUI")) {
            TrueTypeFont var4 = ResourceRegistry.JelloLightFont20;
            int width = Minecraft.getInstance().getMainWindow().getWidth();
            int height = Minecraft.getInstance().getMainWindow().getHeight();
            if (this.initialisedTexture && this.murdererSkinHead != null) {
                this.initialisedTexture = false;
            }
            if (this.murdererSkinHead != null) {
                RenderUtil.drawRoundedRect(width - var4.getWidth(this.murdererSkinName) - 90, height - 130, width - 10, height - 10, 0x50000000);
                RenderUtil.drawImage(width - var4.getWidth(this.murdererSkinName) - 80, height - 120, 50.0f, 100.0f, this.murdererSkinHead);
                RenderUtil.drawString(var4, width - var4.getWidth(this.murdererSkinName) - 20, height - var4.getHeight(this.murdererSkinName) - 60, this.murdererSkinName, -1);
            }
        }
    }

    public void loadMurdererSkinHead(String playerUUID) {
        block4: {
            if (this.murdererSkinHead != null && playerUUID.equals(this.murdererSkinName)) {
                return;
            }
            String skinUrl = "https://crafatar.com/avatars/" + playerUUID + "?size=48";
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(skinUrl).openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setDoInput(true);
                connection.connect();
                BufferedImage bufferedImage = ImageIO.read(connection.getInputStream());
                if (bufferedImage == null) break block4;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.convertBufferedImageToBytes(bufferedImage));
                if (GL11.glGetError() == 0) {
                    this.murdererSkinHead = TextureLoader.getTexture("PNG", (InputStream)inputStream, 9728);
                    break block4;
                }
                throw new IllegalStateException("No OpenGL context is current.");
            }
            catch (Exception e) {
                this.murdererSkinHead = null;
                e.printStackTrace();
            }
        }
    }

    private byte[] convertBufferedImageToBytes(BufferedImage image) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return new byte[0];
            }
        }
        baos.close();
        return byArray;
    }
}

