/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.gui.jello;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2D;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.gui.base.animations.Animation;
import com.mentalfrostbyte.jello.managers.GuiManager;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.game.player.combat.RotationUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.system.math.SmoothInterpolator;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Util;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.annotations.EventTarget;

public class RearView
extends Module {
    public static Framebuffer framebuffer;
    public Animation animation = new Animation(230, 200, Animation.Direction.BACKWARDS);
    public int visibilityTimer = 0;

    public RearView() {
        super(ModuleCategory.GUI, "RearView", "See behind you");
        this.registerSetting((Setting)new BooleanSetting("Show in GUI", "Makes the Rear View visible in guis", false));
        this.registerSetting((Setting)new BooleanSetting("Smart Visibility", "Only pops up when a player is behind you", false));
        this.registerSetting((Setting)new NumberSetting("Size", "The rear view width", 400.0f, 120.0f, 1000.0f, 1.0f));
        this.setAvailableOnClassic(false);
    }

    @EventTarget
    public void onTick(EventUpdate event) {
        if (this.isEnabled() && framebuffer != null && (RearView.framebuffer.framebufferWidth != mc.getMainWindow().getFramebufferWidth() || RearView.framebuffer.framebufferHeight != mc.getMainWindow().getFramebufferHeight())) {
            this.onEnable();
        }
    }

    public boolean isEntityWithinViewAngle(LivingEntity targetEntity) {
        float rotations = RotationUtil.calculateEntityRotations(targetEntity, RearView.mc.player.getPosX(), RearView.mc.player.getPosY(), RearView.mc.player.getPosZ())[0];
        return this.calculateAngleDifference(RearView.mc.player.rotationYaw, rotations) <= 90.0f;
    }

    public float calculateAngleDifference(float angle1, float angle2) {
        float angleDifference = Math.abs(angle2 - angle1) % 360.0f;
        return angleDifference <= 180.0f ? angleDifference : 360.0f - angleDifference;
    }

    @EventTarget
    public void onRender(EventRender2DOffset onRender) {
        if (framebuffer != null && this.isEnabled() && !Minecraft.getInstance().gameSettings.hideGUI) {
            if (!this.getBooleanValueFromSettingName("Smart Visibility")) {
                this.animation.changeDirection(RearView.mc.currentScreen != null && !this.getBooleanValueFromSettingName("Show in GUI") ? Animation.Direction.BACKWARDS : Animation.Direction.FORWARDS);
            } else {
                this.animation.changeDirection(this.visibilityTimer <= 0 ? Animation.Direction.BACKWARDS : Animation.Direction.FORWARDS);
            }
            float aspectRatio = (float)mc.getMainWindow().getWidth() / (float)mc.getMainWindow().getHeight();
            int rearViewWidth = (int)this.getNumberValueBySettingName("Size");
            int rearViewHeight = (int)((float)rearViewWidth / aspectRatio);
            int offset = 10;
            int positionY = -offset - rearViewHeight;
            if (this.animation.calcPercent() == 0.0f && this.animation.calcPercent() == 1.0f) {
                if (this.animation.calcPercent() == 0.0f) {
                    return;
                }
            } else {
                positionY = this.animation.getDirection() != Animation.Direction.FORWARDS ? (int)((float)positionY * SmoothInterpolator.interpolate(this.animation.calcPercent(), 0.49, 0.59, 0.16, 1.04)) : (int)((float)positionY * SmoothInterpolator.interpolate(this.animation.calcPercent(), 0.3, 0.88, 0.47, 1.0));
            }
            RenderUtil.drawRoundedRect((float)(mc.getMainWindow().getWidth() - offset - rearViewWidth), (float)(mc.getMainWindow().getHeight() + positionY), (float)rearViewWidth, (float)(rearViewHeight - 1), 14.0f, this.animation.calcPercent());
            rearViewWidth = (int)((float)rearViewWidth * GuiManager.scaleFactor);
            rearViewHeight = (int)((float)rearViewHeight * GuiManager.scaleFactor);
            offset = (int)((float)offset * GuiManager.scaleFactor);
            positionY = (int)((float)positionY * GuiManager.scaleFactor);
            RenderSystem.pushMatrix();
            this.renderFramebuffer(framebuffer, rearViewWidth, rearViewHeight, mc.getMainWindow().getFramebufferWidth() - offset - rearViewWidth, mc.getMainWindow().getFramebufferHeight() + positionY);
            RenderSystem.popMatrix();
            RenderSystem.clear(256, Minecraft.IS_RUNNING_ON_MAC);
            RenderSystem.matrixMode(5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho(0.0, (double)mc.getMainWindow().getFramebufferWidth() / mc.getMainWindow().getGuiScaleFactor(), (double)mc.getMainWindow().getFramebufferHeight() / mc.getMainWindow().getGuiScaleFactor(), 0.0, 1000.0, 3000.0);
            RenderSystem.matrixMode(5888);
            RenderSystem.loadIdentity();
            RenderSystem.translatef(0.0f, 0.0f, -2000.0f);
            GL11.glScaled((double)(1.0 / mc.getMainWindow().getGuiScaleFactor() * (double)GuiManager.scaleFactor), (double)(1.0 / mc.getMainWindow().getGuiScaleFactor() * (double)GuiManager.scaleFactor), (double)1.0);
            framebuffer.unbindFramebuffer();
            mc.getFramebuffer().bindFramebuffer(true);
        }
    }

    public void renderFramebuffer(Framebuffer var1, int width, int height, double posX, double posY) {
        posY = posY - (double)mc.getMainWindow().getFramebufferHeight() + (double)height;
        RenderSystem.colorMask(true, true, true, false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        RenderSystem.matrixMode(5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho(0.0, (double)width + posX, height, 0.0, 1000.0, 3000.0);
        RenderSystem.matrixMode(5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef(0.0f, 0.0f, -2000.0f);
        RenderSystem.viewport(0, 0, width + (int)posX, height - (int)posY);
        RenderSystem.enableTexture();
        RenderSystem.disableLighting();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.enableColorMaterial();
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        var1.bindFramebufferTexture();
        float var10 = width;
        float var11 = height;
        float var12 = (float)var1.framebufferWidth / (float)var1.framebufferTextureWidth;
        float var13 = (float)var1.framebufferHeight / (float)var1.framebufferTextureHeight;
        Tessellator tezz = RenderSystem.renderThreadTesselator();
        BufferBuilder buffer = tezz.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        buffer.pos(posX, (double)var11 + posY, 0.0).tex(0.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        buffer.pos((double)var10 + posX, (double)var11 + posY, 0.0).tex(var12, 0.0f).color(255, 255, 255, 255).endVertex();
        buffer.pos((double)var10 + posX, posY, 0.0).tex(var12, var13).color(255, 255, 255, 255).endVertex();
        buffer.pos(posX, posY, 0.0).tex(0.0f, var13).color(255, 255, 255, 255).endVertex();
        tezz.draw();
        var1.unbindFramebufferTexture();
        RenderSystem.depthMask(true);
        RenderSystem.colorMask(true, true, true, true);
    }

    @EventTarget
    public void on2D(EventRender2D event) {
        if (this.isEnabled()) {
            if (framebuffer != null) {
                if (RearView.mc.currentScreen == null || this.getBooleanValueFromSettingName("Show in GUI") || this.visibilityTimer != 0) {
                    RenderSystem.pushMatrix();
                    RenderSystem.clear(16640, false);
                    framebuffer.bindFramebuffer(true);
                    RenderSystem.enableTexture();
                    RenderSystem.enableColorMaterial();
                    float newYaw = RearView.mc.player.rotationYaw;
                    RearView.mc.player.rotationYaw += 180.0f;
                    RenderSystem.enableDepthTest();
                    GL11.glAlphaFunc((int)519, (float)0.0f);
                    double newFov = RearView.mc.gameSettings.fov;
                    RearView.mc.gameSettings.fov = 114.0;
                    RearView.mc.gameRenderer.renderHand = false;
                    Client.dontRenderHand = true;
                    Framebuffer var11 = RearView.mc.worldRenderer.getEntityOutlineFramebuffer();
                    RearView.mc.worldRenderer.entityOutlineFramebuffer = null;
                    RearView.mc.gameRenderer.renderWorld(event.partialTicks, Util.nanoTime(), new MatrixStack());
                    RearView.mc.worldRenderer.entityOutlineFramebuffer = var11;
                    Client.dontRenderHand = false;
                    RearView.mc.gameRenderer.renderHand = true;
                    RearView.mc.gameSettings.fov = newFov;
                    RearView.mc.player.rotationYaw = newYaw;
                    RenderSystem.popMatrix();
                    mc.getFramebuffer().bindFramebuffer(true);
                }
            } else {
                this.onEnable();
            }
        }
    }

    @Override
    public void onEnable() {
        framebuffer = new Framebuffer(mc.getMainWindow().getFramebufferWidth(), mc.getMainWindow().getFramebufferHeight(), true, Minecraft.IS_RUNNING_ON_MAC);
        framebuffer.setFramebufferColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void onDisable() {
        this.animation.changeDirection(Animation.Direction.BACKWARDS);
    }
}

