/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.gui.jello;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.util.client.render.Resources;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.annotations.EventTarget;

public class MusicParticles
extends Module {
    public long lastRenderTime = 0L;
    private final List<MusicParticle> particles = new ArrayList<MusicParticle>();

    public MusicParticles() {
        super(ModuleCategory.GUI, "MusicParticles", "Shows nice particles when music is playing");
        this.setAvailableOnClassic(false);
    }

    @EventTarget
    public void onRender(EventRender2DOffset event) {
        if (this.isEnabled() && MusicParticles.mc.player != null) {
            if (Client.getInstance().musicManager.isPlayingSong() && !Client.getInstance().musicManager.visualizerData.isEmpty()) {
                long timeElapsed = System.nanoTime() - this.lastRenderTime;
                float particleIntensity = Math.min(10.0f, Math.max(0.0f, (float)timeElapsed / 1.810361E7f));
                double maxAmplitude = 0.0;
                double maxThreshold = 4750.0;
                if (Client.getInstance().musicManager.amplitudes.isEmpty()) {
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    maxAmplitude = Math.max(maxAmplitude, Math.sqrt(Client.getInstance().musicManager.amplitudes.get(i)) - 1000.0);
                }
                float particleCount = 0.7f + (float)(maxAmplitude / (maxThreshold - 1000.0)) * 8.14f;
                particleCount *= particleIntensity;
                int particleIndex = 0;
                while (this.particles.size() < 40) {
                    this.addParticle();
                    int n = particleIndex++;
                    if (!((float)n > particleCount)) continue;
                }
                this.updateParticles(particleCount);
                for (MusicParticle particle : this.particles) {
                    particle.render();
                }
            }
            this.lastRenderTime = System.nanoTime();
        }
    }

    @Override
    public void onEnable() {
        this.lastRenderTime = System.nanoTime();
    }

    private void addParticle() {
        this.particles.add(new MusicParticle());
    }

    private void updateParticles(float var1) {
        Iterator<MusicParticle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            MusicParticle particle = iterator.next();
            particle.update(var1);
            if (!particle.isExpired()) continue;
            iterator.remove();
        }
    }

    public static class MusicParticle {
        public final float speedFactor = (float)((double)0.1f + Math.random() * (double)0.9f);
        public final float sizeFactor = (float)(0.5 + Math.random() * 0.5);
        public final int startX = (int)((double)Module.mc.getMainWindow().getWidth() * Math.random());
        public final int startY = (int)((double)Module.mc.getMainWindow().getHeight() * Math.random());
        public float lifeProgress;

        public void update(float var1) {
            this.lifeProgress += 0.02f * var1 * this.speedFactor;
        }

        public void render() {
            float scale = 0.3f + this.lifeProgress * 0.7f;
            float alpha = 1.0f;
            if (!(this.lifeProgress < 0.1f)) {
                if (this.lifeProgress > 0.75f) {
                    alpha = 1.0f - (this.lifeProgress - 0.75f) / 0.25f;
                }
            } else {
                alpha = this.lifeProgress / 0.1f;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(Module.mc.getMainWindow().getWidth() / 2), (float)(Module.mc.getMainWindow().getHeight() / 2), (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glTranslatef((float)(-Module.mc.getMainWindow().getWidth() / 2), (float)(-Module.mc.getMainWindow().getHeight() / 2), (float)0.0f);
            int color = Color.getHSBColor((float)(System.currentTimeMillis() % 4000L) / 4000.0f, 0.3f, 1.0f).getRGB();
            float size = 60.0f * this.sizeFactor;
            RenderUtil.drawImage((float)this.startX - size / 2.0f, (float)this.startY - size / 2.0f, size, size, Resources.particlePNG, RenderUtil2.applyAlpha(color, alpha * 0.9f));
            GL11.glPopMatrix();
        }

        public boolean isExpired() {
            return this.lifeProgress >= 1.0f;
        }
    }
}

