/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.gui.jello;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.action.EventKeyPress;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.gui.base.animations.Animation;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.BlurEngine;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import team.sdhq.eventBus.annotations.EventTarget;

public class KeyStrokes
extends Module {
    public int xBase = 10;
    public int yBase = 260;
    public ArrayList<KeyAnimationData> animations = new ArrayList();

    public KeyStrokes() {
        super(ModuleCategory.GUI, "KeyStrokes", "Shows what keybind you are pressing");
        this.setAvailableOnClassic(false);
    }

    public Keystroke getKeyStrokeForKey(int key) {
        Keystroke[] keystrokes;
        for (Keystroke keystroke : keystrokes = Keystroke.values()) {
            assert (keystroke.getKeyBinding() != null);
            if (key != keystroke.getKeyBinding().keyCode.getKeyCode()) continue;
            return keystroke;
        }
        return null;
    }

    @EventTarget
    public void onRender(EventRender2DOffset event) {
        if (this.isEnabled() && KeyStrokes.mc.player != null && !Minecraft.getInstance().gameSettings.showDebugInfo && !Minecraft.getInstance().gameSettings.hideGUI) {
            KeyPosition bottomRightKey;
            KeyPosition topLeftKey;
            this.yBase = event.getYOffset();
            if (Client.getInstance().guiManager.getGuiBlur()) {
                for (Keystroke keystroke : Keystroke.values()) {
                    topLeftKey = keystroke.getTopLeftPosition();
                    bottomRightKey = keystroke.getBottomRightPosition();
                    RenderUtil.drawBlurredBackground(this.xBase + topLeftKey.x, this.yBase + topLeftKey.y, this.xBase + topLeftKey.x + bottomRightKey.x, this.yBase + topLeftKey.y + bottomRightKey.y);
                    BlurEngine.drawBlur(this.xBase + topLeftKey.x, this.yBase + topLeftKey.y, bottomRightKey.x, bottomRightKey.y);
                    BlurEngine.endBlur();
                    RenderUtil.restoreScissor();
                }
            }
            for (Keystroke keystroke : Keystroke.values()) {
                topLeftKey = keystroke.getTopLeftPosition();
                bottomRightKey = keystroke.getBottomRightPosition();
                float topLeftOpacityMul = 1.0f;
                float bottomRightOpacityMul = 1.0f;
                if (Client.getInstance().guiManager.getGuiBlur()) {
                    bottomRightOpacityMul = 0.5f;
                    topLeftOpacityMul = 0.5f;
                }
                String keyName = RenderUtil.getKeyName(keystroke.bind.keyCode.getKeyCode());
                if (keystroke.bind != KeyStrokes.mc.gameSettings.keyBindAttack) {
                    if (keystroke.bind == KeyStrokes.mc.gameSettings.keyBindUseItem) {
                        keyName = "R";
                    }
                } else {
                    keyName = "L";
                }
                if (keystroke.getKeyBinding().isKeyDown()) {
                    RenderUtil.drawRoundedRect(this.xBase + topLeftKey.x, this.yBase + topLeftKey.y, this.xBase + topLeftKey.x + bottomRightKey.x, this.yBase + topLeftKey.y + bottomRightKey.y, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.5f * topLeftOpacityMul));
                } else {
                    RenderUtil.drawRoundedRect(this.xBase + topLeftKey.x, this.yBase + topLeftKey.y, this.xBase + topLeftKey.x + bottomRightKey.x, this.yBase + topLeftKey.y + bottomRightKey.y, RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), 0.5f * topLeftOpacityMul));
                }
                RenderUtil.drawRoundedRect((float)(this.xBase + topLeftKey.x), (float)(this.yBase + topLeftKey.y), (float)bottomRightKey.x, (float)bottomRightKey.y, 10.0f, 0.75f * bottomRightOpacityMul);
                RenderUtil.drawString(ResourceRegistry.JelloLightFont18, this.xBase + topLeftKey.x + (bottomRightKey.x - ResourceRegistry.JelloLightFont18.getWidth(keyName)) / 2, this.yBase + topLeftKey.y + 12, keyName, ClientColors.LIGHT_GREYISH_BLUE.getColor());
            }
            Iterator<KeyAnimationData> iter = this.animations.iterator();
            while (iter.hasNext()) {
                KeyAnimationData animationData = iter.next();
                Keystroke keyStroke = animationData.keyStroke;
                KeyPosition topLeftPosition = keyStroke.getTopLeftPosition();
                KeyPosition bottomRightPosition = keyStroke.getBottomRightPosition();
                RenderUtil.drawBlurredBackground(this.xBase + topLeftPosition.x, this.yBase + topLeftPosition.y, this.xBase + topLeftPosition.x + bottomRightPosition.x, this.yBase + topLeftPosition.y + bottomRightPosition.y);
                float maxAnimPercent = 0.7f;
                int duplicates = 0;
                for (KeyAnimationData animationData1 : this.animations) {
                    if (!animationData1.keyStroke.equals((Object)keyStroke)) continue;
                    ++duplicates;
                }
                if (keyStroke.getKeyBinding().isKeyDown() && animationData.animation.calcPercent() >= maxAnimPercent && duplicates < 2) {
                    animationData.animation.updateStartTime(maxAnimPercent);
                }
                float animPercent = animationData.animation.calcPercent();
                float alpha = (1.0f - animPercent * (0.5f + animPercent * 0.5f)) * 0.8f;
                int color = RenderUtil2.applyAlpha(-5658199, alpha);
                if (Client.getInstance().guiManager.getGuiBlur()) {
                    color = RenderUtil2.applyAlpha(-1, alpha);
                }
                RenderUtil.drawFilledArc(this.xBase + topLeftPosition.x + bottomRightPosition.x / 2, this.yBase + topLeftPosition.y + bottomRightPosition.y / 2, (float)(bottomRightPosition.x - 4) * animPercent + 4.0f, color);
                RenderUtil.restoreScissor();
                if (animationData.animation.calcPercent() != 1.0f) continue;
                iter.remove();
            }
            event.addOffset(160);
        }
    }

    @EventTarget
    public void onKeyPress(EventKeyPress event) {
        if (this.isEnabled() && KeyStrokes.mc.player != null && this.getKeyStrokeForKey(event.getKey()) != null && !event.isPressed()) {
            this.animations.add(new KeyAnimationData(this.getKeyStrokeForKey(event.getKey())));
        }
    }

    public static enum Keystroke {
        Left(0.0f, 1.0f, Module.mc.gameSettings.keyBindLeft),
        Right(2.0f, 1.0f, Module.mc.gameSettings.keyBindRight),
        Forward(1.0f, 0.0f, Module.mc.gameSettings.keyBindForward),
        Back(1.0f, 1.0f, Module.mc.gameSettings.keyBindBack),
        Attack(0.0f, 2.0f, 74, Module.mc.gameSettings.keyBindAttack),
        UseItem(1.02f, 2.0f, 73, Module.mc.gameSettings.keyBindUseItem);

        public final float positionX;
        public final float positionY;
        public int width = 48;
        public int height = 48;
        public int padding = 3;
        public final KeyBinding bind;

        private Keystroke(float positionX, float positionY, KeyBinding bind) {
            this.positionX = positionX;
            this.positionY = positionY;
            this.bind = bind;
        }

        private Keystroke(float positionX, float positionY, int width, KeyBinding bind) {
            this.positionX = positionX;
            this.positionY = positionY;
            this.bind = bind;
            this.width = width;
        }

        public KeyPosition getTopLeftPosition() {
            return new KeyPosition(this, (int)(this.positionX * (float)(this.width + this.padding)), (int)(this.positionY * (float)(this.height + this.padding)));
        }

        public KeyPosition getBottomRightPosition() {
            return new KeyPosition(this, this.width, this.height);
        }

        public KeyBinding getKeyBinding() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case Left -> Module.mc.gameSettings.keyBindLeft;
                case Right -> Module.mc.gameSettings.keyBindRight;
                case Forward -> Module.mc.gameSettings.keyBindForward;
                case Back -> Module.mc.gameSettings.keyBindBack;
                case Attack -> Module.mc.gameSettings.keyBindAttack;
                case UseItem -> Module.mc.gameSettings.keyBindUseItem;
            };
        }
    }

    public static class KeyPosition {
        public int x;
        public int y;
        public final Keystroke keystroke;

        public KeyPosition(Keystroke keystroke, int x, int y) {
            this.keystroke = keystroke;
            this.x = x;
            this.y = y;
        }
    }

    public static class KeyAnimationData {
        public Keystroke keyStroke;
        public Animation animation = new Animation(300, 0);

        public KeyAnimationData(Keystroke keyStroke) {
            this.keyStroke = keyStroke;
        }
    }
}

