/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.gui.jello;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRenderChat;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.util.client.render.ResourceRegistry;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.AirItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import org.lwjgl.opengl.GL11;
import team.sdhq.eventBus.annotations.EventTarget;

public class InfoHUD
extends Module {
    public InfoHUD() {
        super(ModuleCategory.GUI, "Info HUD", "Shows a bunch of usefull stuff");
        this.registerSetting((Setting)new ModeSetting("Cords", "Coordinate display type", 1, "None", "Normal", "Precise"));
        this.registerSetting((Setting)new BooleanSetting("Show Player", "Renders a miniature version of your character", true));
        this.registerSetting((Setting)new BooleanSetting("Show Armor", "Shows your armor's status", true));
        this.registerSetting((Setting)new BooleanSetting("Move chat up", "Moves the chat gui up", true));
        this.setAvailableOnClassic(false);
    }

    @EventTarget
    public void onRenderChat(EventRenderChat eventRenderChat) {
        if (this.getBooleanValueFromSettingName("Move chat up")) {
            eventRenderChat.addOffset(-40);
        }
    }

    @EventTarget
    public void onRender2D(EventRender2DOffset event) {
        if (this.isEnabled() && InfoHUD.mc.player != null && !Minecraft.getInstance().gameSettings.hideGUI && !(InfoHUD.mc.currentScreen instanceof IngameMenuScreen)) {
            int y;
            int xOffset = 14;
            if (this.getBooleanValueFromSettingName("Show Player")) {
                y = InfoHUD.mc.mainWindow.getHeight() - 22;
                if (Client.getInstance().musicManager.isPlayingSong()) {
                    y -= 105;
                }
                xOffset += this.renderPlayerModel(0, y, 114);
            }
            if (this.getBooleanValueFromSettingName("Show Armor")) {
                y = InfoHUD.mc.mainWindow.getHeight() - 14;
                if (Client.getInstance().musicManager.isPlayingSong()) {
                    y -= 105;
                }
                xOffset += this.renderArmorStatus(xOffset, y) + 10;
            }
            if (!this.getStringSettingValueByName("Cords").equals("None")) {
                y = 42;
                if (Client.getInstance().musicManager.isPlayingSong()) {
                    y += 105;
                }
                int n = xOffset + (this.renderCoordinates(xOffset, y) + 10);
            }
        }
    }

    public String getFormattedCoordinates(boolean precise) {
        return !precise ? Math.round(InfoHUD.mc.player.getPosX()) + " " + Math.round(InfoHUD.mc.player.getPosY()) + " " + Math.round(InfoHUD.mc.player.getPosZ()) : (float)Math.round(InfoHUD.mc.player.getPosX() * 10.0) / 10.0f + " " + (float)Math.round(InfoHUD.mc.player.getPosY() * 10.0) / 10.0f + " " + (float)Math.round(InfoHUD.mc.player.getPosZ() * 10.0) / 10.0f;
    }

    public int renderCoordinates(int x, int yOffset) {
        String direction = "Facing South";
        String coordinates = this.getFormattedCoordinates(this.getStringSettingValueByName("Cords").equals("Precise"));
        RenderUtil.drawString(ResourceRegistry.JelloMediumFont20, x, InfoHUD.mc.mainWindow.getHeight() - yOffset, coordinates, RenderUtil.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), 0.8f));
        return Math.max(ResourceRegistry.JelloLightFont20.getWidth(direction), ResourceRegistry.JelloMediumFont20.getWidth(coordinates));
    }

    public int renderArmorStatus(int x, int y) {
        int armorCount = 0;
        for (int i = 0; i < InfoHUD.mc.player.inventory.armorInventory.size(); ++i) {
            ItemStack armorPiece = InfoHUD.mc.player.inventory.armorInventory.get(i);
            if (armorPiece.getItem() instanceof AirItem) continue;
            int armorY = y - 32 * ++armorCount;
            RenderUtil.renderItem(armorPiece, x, armorY, 32, 32);
            GL11.glDisable((int)2896);
            float durability = 1.0f - (float)armorPiece.getDamage() / (float)armorPiece.getMaxDamage();
            if (durability == 1.0f) continue;
            RenderUtil.drawRect2(x + 2, armorY + 28, 28.0f, 5.0f, RenderUtil.applyAlpha(ClientColors.DEEP_TEAL.getColor(), 0.5f));
            RenderUtil.drawRect2(x + 2, armorY + 28, 28.0f * durability, 3.0f, RenderUtil.applyAlpha((double)durability > 0.2 ? ClientColors.DARK_SLATE_GREY.getColor() : ClientColors.PALE_YELLOW.getColor(), 0.9f));
        }
        return armorCount != 0 ? 32 : -7;
    }

    public int renderPlayerModel(int x, int y, int height) {
        this.drawEntityOnScreen(x + height / 2, y, height / 2, InfoHUD.mc.player);
        return height - 24;
    }

    private void drawEntityOnScreen(int posX, int posY, int scale, LivingEntity livingEntity) {
        float fixedYaw = livingEntity.rotationYaw;
        float fixedPitch = livingEntity.rotationPitch;
        RenderSystem.pushMatrix();
        RenderSystem.translatef(posX, posY, 1050.0f);
        RenderSystem.scalef(1.0f, 1.0f, -1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.translate(0.0, 0.0, 1000.0);
        matrixstack.scale(scale, scale, scale);
        Quaternion quaternion = Vector3f.ZP.rotationDegrees(180.0f);
        matrixstack.rotate(quaternion);
        float f2 = livingEntity.renderYawOffset;
        float f3 = livingEntity.rotationYaw;
        float f4 = livingEntity.rotationPitch;
        float f5 = livingEntity.prevRotationYawHead;
        float f6 = livingEntity.rotationYawHead;
        livingEntity.renderYawOffset = f2;
        livingEntity.rotationYaw = fixedYaw;
        livingEntity.rotationPitch = fixedPitch;
        livingEntity.rotationYawHead = f6;
        livingEntity.prevRotationYawHead = f5;
        EntityRendererManager entityrenderermanager = Minecraft.getInstance().getRenderManager();
        entityrenderermanager.setCameraOrientation(new Quaternion(0.0f, 0.0f, 0.0f, 1.0f));
        entityrenderermanager.setRenderShadow(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.getInstance().getRenderTypeBuffers().getBufferSource();
        RenderSystem.runAsFancy(() -> entityrenderermanager.renderEntityStatic(livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.finish();
        entityrenderermanager.setRenderShadow(true);
        livingEntity.renderYawOffset = f2;
        livingEntity.rotationYaw = f3;
        livingEntity.rotationPitch = f4;
        livingEntity.prevRotationYawHead = f5;
        livingEntity.rotationYawHead = f6;
        RenderSystem.popMatrix();
    }
}

