/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.impl.gui.classic;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.event.impl.game.action.EventKeyPress;
import com.mentalfrostbyte.jello.event.impl.game.render.EventRender2DOffset;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.gui.base.animations.Animation;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.data.ModuleWithModuleSettings;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.BooleanSetting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.module.settings.impl.NumberSetting;
import com.mentalfrostbyte.jello.util.client.ClientMode;
import com.mentalfrostbyte.jello.util.client.render.classicgui.CategoryDrawPart;
import com.mentalfrostbyte.jello.util.client.render.classicgui.CategoryDrawPartBackground;
import com.mentalfrostbyte.jello.util.client.render.theme.ClientColors;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mentalfrostbyte.jello.util.system.math.MathHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import team.sdhq.eventBus.annotations.EventTarget;
import team.sdhq.eventBus.annotations.priority.HighestPriority;

public class TabGUI
extends Module {
    public static final Animation animationProgress = new Animation(200, 200, Animation.Direction.BACKWARDS);
    public Animation secondAnimationProgress = new Animation(500, 0, Animation.Direction.BACKWARDS);
    private final Animation firstAnimationProgress = new Animation(300, 300, Animation.Direction.BACKWARDS);
    private final List<ModuleCategory> categories = new ArrayList<ModuleCategory>();
    private int animationCooldown = 0;
    private static final List<CategoryDrawPart> categoryDrawParts = new ArrayList<CategoryDrawPart>();

    public TabGUI() {
        super(ModuleCategory.GUI, "TabGUI", "Manage mods without opening the ClickGUI");
    }

    @Override
    public void initialize() {
        this.categories.add(ModuleCategory.COMBAT);
        this.categories.add(ModuleCategory.PLAYER);
        this.categories.add(ModuleCategory.MOVEMENT);
        this.categories.add(ModuleCategory.RENDER);
        this.categories.add(ModuleCategory.WORLD);
        this.categories.add(ModuleCategory.MISC);
        ArrayList<String> categoryList = new ArrayList<String>();
        for (ModuleCategory category : this.categories) {
            categoryList.add(category.name());
        }
        categoryDrawParts.add(0, new CategoryDrawPart(categoryList, 0));
    }

    @EventTarget
    public void onKeyPress(EventKeyPress event) {
        KeyAction action;
        if (Client.getInstance().clientMode == ClientMode.JELLO) {
            return;
        }
        if (this.isEnabled() && (action = TabGUI.mapKeyToAction(event.getKey())) != null) {
            animationProgress.changeDirection(Animation.Direction.FORWARDS);
            this.animationCooldown = 80;
            int categoryState = this.getCurrentCategoryState();
            CategoryDrawPart category = categoryDrawParts.get(categoryState - 1);
            if (action != KeyAction.EnterKey && (!this.isAnimationForwards() && action != KeyAction.RightArrowKey || categoryState != 3)) {
                this.secondAnimationProgress = new Animation(500, 200, Animation.Direction.BACKWARDS);
            }
            switch (action) {
                case LeftArrowKey: {
                    if (categoryState == 3 && this.isAnimationForwards()) {
                        this.setAnimationDirection(false);
                        break;
                    }
                    if (categoryState <= 1) break;
                    if (categoryDrawParts.get(categoryDrawParts.size() - 1).isExpanded()) {
                        categoryDrawParts.remove(categoryDrawParts.size() - 1);
                    }
                    category.expand();
                    break;
                }
                case DownArrowKey: {
                    if (categoryState == 3 && this.isAnimationForwards()) {
                        this.onSettingChange(true);
                        break;
                    }
                    if (category == null) break;
                    category.scrollDown();
                    break;
                }
                case UpArrowKey: {
                    if (categoryState == 3 && this.isAnimationForwards()) {
                        this.onSettingChange(false);
                        break;
                    }
                    if (category == null) break;
                    category.scrollUp();
                    break;
                }
                case RightArrowKey: {
                    if (categoryState == 1) {
                        this.updateCategoryParts(this.categories.get(category.currentOffset));
                        break;
                    }
                    if (categoryState == 2 && category != null) {
                        CategoryDrawPart drawPart = categoryDrawParts.get(0);
                        ModuleCategory modCategory = this.categories.get(drawPart.currentOffset);
                        Module module = Client.getInstance().moduleManager.getModulesByCategory(modCategory).get(category.currentOffset);
                        this.updateModuleSettingsParts(module);
                        break;
                    }
                    if (categoryState != 3) break;
                    this.setAnimationDirection(true);
                    break;
                }
                case EnterKey: {
                    Module mod;
                    if (categoryState != 2 || category == null) break;
                    CategoryDrawPart drawPart = categoryDrawParts.get(0);
                    ModuleCategory modCat = this.categories.get(drawPart.currentOffset);
                    mod.setEnabled(!(mod = Client.getInstance().moduleManager.getModulesByCategory(modCat).get(category.currentOffset)).isEnabled());
                }
            }
        }
    }

    private void onSettingChange(boolean goDown) {
        CategoryDrawPart categoryIndex = categoryDrawParts.get(0);
        CategoryDrawPart moduleIndex = categoryDrawParts.get(1);
        CategoryDrawPart settingIndex = categoryDrawParts.get(2);
        ModuleCategory category = this.categories.get(categoryIndex.currentOffset);
        Module module = Client.getInstance().moduleManager.getModulesByCategory(category).get(moduleIndex.currentOffset);
        Setting setting = this.getModuleSettings(module).get(settingIndex.currentOffset);
        if (!(setting instanceof ModeSetting)) {
            if (!(setting instanceof BooleanSetting)) {
                NumberSetting numberSetting;
                Object obj;
                if (setting instanceof NumberSetting && (obj = (numberSetting = (NumberSetting)setting).getCurrentValue()) != null) {
                    Float value = (Float)numberSetting.getCurrentValue();
                    value = goDown ? Float.valueOf(value.floatValue() - numberSetting.getStep()) : Float.valueOf(value.floatValue() + numberSetting.getStep());
                    value = Float.valueOf(Math.min(Math.max(value.floatValue(), numberSetting.getMin()), numberSetting.getMax()));
                    numberSetting.setCurrentValue(value);
                }
            } else {
                BooleanSetting bool = (BooleanSetting)setting;
                bool.setCurrentValue(bool.getCurrentValue() == false);
            }
        } else {
            ModeSetting mode = (ModeSetting)setting;
            int index = mode.getModeIndex();
            index = !goDown ? --index : ++index;
            if (index > mode.getAvailableModes().size() - 1) {
                index = 0;
            }
            if (index < 0) {
                index = mode.getAvailableModes().size() - 1;
            }
            mode.setModeByIndex(index);
        }
        settingIndex.setCategories(this.getModuleSettingsWithValues(module));
    }

    @EventTarget
    public void onTick(EventUpdate event) {
        if (Client.getInstance().clientMode == ClientMode.JELLO) {
            return;
        }
        if (this.isEnabled()) {
            if (this.animationCooldown <= 0) {
                animationProgress.changeDirection(Animation.Direction.BACKWARDS);
                this.secondAnimationProgress.changeDirection(Animation.Direction.BACKWARDS);
            } else {
                --this.animationCooldown;
            }
        }
    }

    @EventTarget
    @HighestPriority
    public void onRender(EventRender2DOffset event) {
        if (Client.getInstance().clientMode == ClientMode.JELLO) {
            return;
        }
        if (this.isEnabled() && TabGUI.mc.player != null && !Minecraft.getInstance().gameSettings.showDebugInfo && !Minecraft.getInstance().gameSettings.hideGUI) {
            this.refreshCategoryModules();
            for (CategoryDrawPartBackground categoryDrawPartBackground : categoryDrawParts) {
                categoryDrawPartBackground.render((float)(0.5 + (double)animationProgress.calcPercent() * 0.5));
            }
            this.drawCategories((float)(0.5 + (double)animationProgress.calcPercent() * 0.5));
            RenderUtil.drawRoundedRect2(12.0f, 30.0f, 90.0f, 1.0f, ClientColors.LIGHT_GREYISH_BLUE.getColor());
        }
    }

    private void refreshCategoryModules() {
        if (categoryDrawParts.size() >= 2) {
            CategoryDrawPart categoryDisplay = categoryDrawParts.get(1);
            CategoryDrawPart activeCategory = categoryDrawParts.get(0);
            ModuleCategory currentCategory = this.categories.get(activeCategory.currentOffset);
            int index = 0;
            for (Module module : Client.getInstance().moduleManager.getModulesByCategory(currentCategory)) {
                categoryDisplay.updateCategory(index++, (!module.isEnabled() ? "\u00a77" : "") + module.getFormattedName());
            }
        }
    }

    private void drawCategories(float partialTicks) {
        try {
            int drawState = this.getCurrentCategoryState();
            if (drawState == 2 || drawState == 3) {
                CategoryDrawPart firstCategoryPart = categoryDrawParts.get(0);
                CategoryDrawPart secondCategoryPart = categoryDrawParts.get(1);
                CategoryDrawPart thirdCategoryPart = drawState != 3 ? null : categoryDrawParts.get(2);
                CategoryDrawPart activeCategoryPart = secondCategoryPart;
                if (thirdCategoryPart != null) {
                    activeCategoryPart = thirdCategoryPart;
                }
                if (activeCategoryPart.isAnimating() && animationProgress.getDirection() == Animation.Direction.FORWARDS) {
                    if (this.getCurrentCategoryState() == categoryDrawParts.size()) {
                        this.secondAnimationProgress.changeDirection(Animation.Direction.FORWARDS);
                    } else if (categoryDrawParts.get(categoryDrawParts.size() - 1).isFullyCollapsed()) {
                        this.secondAnimationProgress.changeDirection(Animation.Direction.FORWARDS);
                    }
                }
                ModuleCategory currentCategory = this.categories.get(firstCategoryPart.currentOffset);
                Module currentModule = Client.getInstance().moduleManager.getModulesByCategory(currentCategory).get(secondCategoryPart.currentOffset);
                String description = currentModule.getDescription();
                if (drawState == 3) {
                    Setting currentSetting = this.getModuleSettings(currentModule).get(thirdCategoryPart.currentOffset);
                    description = currentSetting.getDescription();
                }
                float animationProgressValue = MathHelper.calculateTransition(this.firstAnimationProgress.calcPercent(), 0.0f, 1.0f, 1.0f) * animationProgress.calcPercent();
                if (this.firstAnimationProgress.getDirection() == Animation.Direction.BACKWARDS) {
                    animationProgressValue = MathHelper.calculateBackwardTransition(this.firstAnimationProgress.calcPercent(), 0.0f, 1.0f, 1.0f);
                }
                RenderUtil.renderCategoryBox((float)activeCategoryPart.getStartX() + (float)activeCategoryPart.getWidth() + 14.0f * animationProgressValue, (float)activeCategoryPart.getStartY() + 16.0f + (float)(25 * activeCategoryPart.currentOffset), 24.0f * animationProgressValue, RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), partialTicks * 0.6f), RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), partialTicks * 0.6f));
                int descriptionX = activeCategoryPart.getStartX() + activeCategoryPart.getWidth() + 4 + Math.round(animationProgressValue * 28.0f);
                int descriptionY = activeCategoryPart.getStartY() + 25 * activeCategoryPart.currentOffset + 4;
                int descriptionWidth = activeCategoryPart.font.getWidth(description) + 8;
                float secondAnimationValue = MathHelper.calculateTransition(this.secondAnimationProgress.calcPercent(), 0.0f, 1.0f, 1.0f);
                RenderUtil.drawRoundedRect2(descriptionX, descriptionY, (float)descriptionWidth * secondAnimationValue, 25.0f, RenderUtil2.applyAlpha(ClientColors.DEEP_TEAL.getColor(), partialTicks * 0.6f));
                RenderUtil.startScissor(descriptionX, descriptionY, (float)descriptionWidth * secondAnimationValue, 25.0f);
                RenderUtil.drawString(activeCategoryPart.font, descriptionX + 4, descriptionY + 2, description, RenderUtil2.applyAlpha(ClientColors.LIGHT_GREYISH_BLUE.getColor(), Math.min(1.0f, partialTicks * 1.7f)));
                RenderUtil.restoreScissor();
            }
        }
        catch (IndexOutOfBoundsException e) {
            Client.logger.warn("bruh your modules aren't enough for this sexy ass tabgui", (Throwable)e);
        }
    }

    public static KeyAction mapKeyToAction(int keyCode) {
        switch (keyCode) {
            case 257: {
                return KeyAction.EnterKey;
            }
            default: {
                return null;
            }
            case 262: {
                return KeyAction.RightArrowKey;
            }
            case 263: {
                return KeyAction.LeftArrowKey;
            }
            case 264: {
                return KeyAction.DownArrowKey;
            }
            case 265: 
        }
        return KeyAction.UpArrowKey;
    }

    public static int calculateStartX(int index) {
        int totalWidth = 0;
        for (int i = 0; i < index; ++i) {
            totalWidth += categoryDrawParts.get(i).getWidth();
        }
        return 4 + totalWidth + 5 * index;
    }

    public void updateCategoryParts(ModuleCategory category) {
        ArrayList<String> suffixes = new ArrayList<String>();
        for (Module module : Client.getInstance().moduleManager.getModulesByCategory(category)) {
            suffixes.add(module.getFormattedName());
        }
        this.removePartsByThreshold(1);
        categoryDrawParts.add(1, new CategoryDrawPart(suffixes, 1));
    }

    public void updateModuleSettingsParts(Module module) {
        List<String> settings = this.getModuleSettingsWithValues(module);
        if (!settings.isEmpty()) {
            this.removePartsByThreshold(2);
            categoryDrawParts.add(2, new CategoryDrawPart(settings, 2));
        }
    }

    public void removePartsByThreshold(int threshold) {
        categoryDrawParts.removeIf(categoryDrawPart -> categoryDrawPart.priority >= threshold);
    }

    @Override
    public void onDisable() {
        animationProgress.changeDirection(Animation.Direction.BACKWARDS);
        this.animationCooldown = 0;
    }

    @Override
    public void onEnable() {
        animationProgress.changeDirection(Animation.Direction.FORWARDS);
        this.animationCooldown = 40;
    }

    public List<String> getModuleSettingsWithValues(Module module) {
        ArrayList<String> settings = new ArrayList<String>();
        for (Setting setting : this.getModuleSettings(module)) {
            settings.add(setting.getName() + " " + String.valueOf(setting.getCurrentValue()));
        }
        return settings;
    }

    public List<Setting> getModuleSettings(Module module) {
        ArrayList<Setting> setting = new ArrayList<Setting>(module.getSettingMap().values());
        if (module instanceof ModuleWithModuleSettings) {
            ModuleWithModuleSettings moduleWithSubModules = (ModuleWithModuleSettings)module;
            moduleWithSubModules.calledOnEnable();
            if (moduleWithSubModules.getModWithTypeSetToName() != null) {
                setting.addAll(moduleWithSubModules.getModWithTypeSetToName().getSettingMap().values());
            }
        }
        setting.removeIf(nextSetting -> nextSetting.getName().equals("Keybind"));
        return setting;
    }

    private int getCurrentCategoryState() {
        CategoryDrawPartBackground lastPart = categoryDrawParts.get(categoryDrawParts.size() - 1);
        int visibleCount = categoryDrawParts.size();
        if (lastPart.isExpanded()) {
            --visibleCount;
        }
        return visibleCount;
    }

    private void setAnimationDirection(boolean isForwards) {
        this.firstAnimationProgress.changeDirection(!isForwards ? Animation.Direction.BACKWARDS : Animation.Direction.FORWARDS);
    }

    private boolean isAnimationForwards() {
        return this.firstAnimationProgress.getDirection() == Animation.Direction.FORWARDS;
    }

    public static enum KeyAction {
        RightArrowKey,
        LeftArrowKey,
        EnterKey,
        UpArrowKey,
        DownArrowKey;

    }
}

