/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.module.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mentalfrostbyte.jello.module.Module;
import com.mentalfrostbyte.jello.module.data.ModuleCategory;
import com.mentalfrostbyte.jello.module.data.ModuleStateListener;
import com.mentalfrostbyte.jello.module.settings.Setting;
import com.mentalfrostbyte.jello.module.settings.impl.ModeSetting;
import com.mentalfrostbyte.jello.util.system.other.GsonUtil;
import java.util.ArrayList;
import java.util.List;
import team.sdhq.eventBus.EventBus;

public class ModuleWithModuleSettings
extends Module {
    private final List<ModuleStateListener> moduleStateListeners = new ArrayList<ModuleStateListener>();
    public Module[] moduleArray;
    public Module parentModule;
    public ModeSetting modeSetting;
    public String customModeName;
    private final List<String> stringList = new ArrayList<String>();

    public ModuleWithModuleSettings(ModuleCategory category, String type, String description, Module ... modules) {
        this(category, type, description, "Type", modules);
    }

    public ModuleWithModuleSettings(ModuleCategory category, String type, String description, String customModeName, Module ... modules) {
        super(category, type, description);
        for (Module moduleFromArray : this.moduleArray = modules) {
            EventBus.register(moduleFromArray);
            this.stringList.add(moduleFromArray.getName());
            moduleFromArray.setSomeMod(this);
        }
        this.customModeName = customModeName;
        this.modeSetting = new ModeSetting(customModeName, type + " mode", 0, this.stringList.toArray(new String[0]));
        this.registerSetting((Setting)this.modeSetting);
        this.modeSetting.addObserver(var1x -> this.calledOnEnable());
        this.calledOnEnable();
    }

    public void calledOnEnable() {
        this.isTypeSetToThisModName();
        for (Module module : this.moduleArray) {
            boolean isParent = this.getStringSettingValueByName(this.customModeName).equals(module.name);
            if (this.isEnabled() && ModuleWithModuleSettings.mc.player != null) {
                module.setState(isParent);
                if (isParent) {
                    this.parentModule = module;
                }
            } else if (this.isEnabled()) {
                module.setEnabledBasic(isParent);
            }
            this.setModuleEnabled(module, isParent);
        }
    }

    private void isTypeSetToThisModName() {
        boolean isOurName = false;
        for (Module module : this.moduleArray) {
            if (!this.getStringSettingValueByName(this.customModeName).equals(module.name)) continue;
            isOurName = true;
        }
        if (!isOurName) {
            this.setSetting(this.customModeName, this.moduleArray[0].name);
        }
    }

    public Module getModWithTypeSetToName() {
        this.isTypeSetToThisModName();
        for (Module mod : this.moduleArray) {
            if (!this.getStringSettingValueByName(this.customModeName).equals(mod.name)) continue;
            return mod;
        }
        return null;
    }

    @Override
    public boolean isEnabled2() {
        if (this.parentModule == null) {
            this.calledOnEnable();
        }
        return this.parentModule != null ? this.parentModule.isEnabled2() : this.isEnabled();
    }

    @Override
    public JsonObject initialize(JsonObject config) throws JsonParseException {
        JsonObject subOptions = GsonUtil.getJSONObjectOrNull(config, "sub-options");
        if (subOptions != null) {
            for (Module module : this.moduleArray) {
                JsonArray var9 = GsonUtil.getJSONArrayOrNull(subOptions, module.getName());
                if (var9 == null) continue;
                block3: for (int var10 = 0; var10 < var9.size(); ++var10) {
                    JsonObject var11 = var9.get(var10).getAsJsonObject();
                    String var12 = GsonUtil.getStringOrDefault(var11, "name", null);
                    for (Setting var14 : module.settingMap.values()) {
                        if (!var14.getName().equals(var12)) continue;
                        try {
                            var14.loadCurrentValueFromJSONObject(var11);
                            continue block3;
                        }
                        catch (JsonParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
        JsonObject var18 = super.initialize(config);
        if (this.enabled) {
            this.calledOnEnable();
        }
        return var18;
    }

    @Override
    public JsonObject buildUpModuleData(JsonObject obj) {
        try {
            JsonObject subOptionsObj = new JsonObject();
            for (Module mod : this.moduleArray) {
                JsonArray arr = new JsonArray();
                for (Setting setting : mod.settingMap.values()) {
                    arr.add((JsonElement)setting.buildUpSettingData(new JsonObject()));
                }
                subOptionsObj.add(mod.getName(), (JsonElement)arr);
            }
            obj.add("sub-options", (JsonElement)subOptionsObj);
            return super.buildUpModuleData(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onEnable() {
        this.calledOnEnable();
    }

    @Override
    public void onDisable() {
        for (Module var6 : this.moduleArray) {
            var6.setEnabled(false);
        }
    }

    @Override
    public void resetModuleState() {
        for (Module var6 : this.moduleArray) {
            var6.setState(false);
        }
        super.resetModuleState();
    }

    public final void addModuleStateListener(ModuleStateListener listener) {
        this.moduleStateListeners.add(listener);
    }

    public final void setModuleEnabled(Module module, boolean enabled) {
        for (ModuleStateListener listener : this.moduleStateListeners) {
            listener.onModuleEnabled(this, module, enabled);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        for (Module mod : this.moduleArray) {
            mod.initialize();
        }
    }
}

