/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.managers;

import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.command.Command;
import com.mentalfrostbyte.jello.command.impl.Bind;
import com.mentalfrostbyte.jello.command.impl.ClearChat;
import com.mentalfrostbyte.jello.command.impl.Config;
import com.mentalfrostbyte.jello.command.impl.Damage;
import com.mentalfrostbyte.jello.command.impl.Enchant;
import com.mentalfrostbyte.jello.command.impl.Enemy;
import com.mentalfrostbyte.jello.command.impl.EntityDesync;
import com.mentalfrostbyte.jello.command.impl.Friend;
import com.mentalfrostbyte.jello.command.impl.HClip;
import com.mentalfrostbyte.jello.command.impl.Help;
import com.mentalfrostbyte.jello.command.impl.HighDPI;
import com.mentalfrostbyte.jello.command.impl.Insult;
import com.mentalfrostbyte.jello.command.impl.KillPotion;
import com.mentalfrostbyte.jello.command.impl.Panic;
import com.mentalfrostbyte.jello.command.impl.Peek;
import com.mentalfrostbyte.jello.command.impl.TP;
import com.mentalfrostbyte.jello.command.impl.Toggle;
import com.mentalfrostbyte.jello.command.impl.VClip;
import com.mentalfrostbyte.jello.event.impl.game.network.EventSendPacket;
import com.mentalfrostbyte.jello.event.impl.player.EventUpdate;
import com.mentalfrostbyte.jello.managers.data.Manager;
import com.mentalfrostbyte.jello.managers.util.command.ChatCommandArguments;
import com.mentalfrostbyte.jello.managers.util.command.CommandException;
import com.mentalfrostbyte.jello.util.client.ClientMode;
import com.mentalfrostbyte.jello.util.game.MinecraftUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import team.sdhq.eventBus.annotations.EventTarget;

public class CommandManager
extends Manager {
    public static final String CHAT_COMMAND_CHAR = ".";
    public static final String CHAT_PREFIX = "\u00a7f[\u00a76Sigma\u00a7f]\u00a77";
    private static final List<Runnable> runnableList = new ArrayList<Runnable>();
    public List<Command> commands = new ArrayList<Command>();
    private boolean field38298 = true;

    public static void runRunnable(Runnable runnable) {
        runnableList.add(runnable);
    }

    @Override
    public void init() {
        super.init();
        this.register(new VClip());
        this.register(new HClip());
        this.register(new Damage());
        this.register(new ClearChat());
        this.register(new EntityDesync());
        this.register(new Peek());
        this.register(new Insult());
        this.register(new Bind());
        this.register(new Help());
        this.register(new Friend());
        this.register(new Enemy());
        this.register(new Toggle());
        this.register(new Config());
        this.register(new Panic());
        this.register(new HighDPI());
        this.register(new KillPotion());
        this.register(new Enchant());
        this.register(new TP());
    }

    public Command getCommandByName(String var1) {
        for (Command var5 : this.commands) {
            if (!var5.getName().equals(var1)) continue;
            return var5;
        }
        for (Command command : this.commands) {
            for (String var9 : command.getAlias()) {
                if (!var9.equals(var1)) continue;
                return command;
            }
        }
        return null;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    private void register(Command command) {
        this.commands.add(command);
    }

    public void invalidCommandMessage(String name) {
        MinecraftUtil.addChatMessage(this.getPrefix() + " Invalid command \"." + name + "\"");
        MinecraftUtil.addChatMessage(this.getPrefix() + " Use \".help\" for a list of commands.");
    }

    public String getPrefix() {
        if (this.field38298) {
            this.field38298 = false;
            return CHAT_PREFIX;
        }
        StringBuilder var3 = new StringBuilder();
        for (int var4 = 0; var4 < 8; ++var4) {
            var3.append(" ");
        }
        return String.valueOf(var3) + "\u00a77";
    }

    public void method30236() {
        this.field38298 = true;
    }

    @EventTarget
    public void method30237(EventUpdate var1) {
        for (Runnable var5 : runnableList) {
            var5.run();
        }
        runnableList.clear();
    }

    @EventTarget
    public void onSendPacket(EventSendPacket event) {
        if (Client.getInstance().clientMode != ClientMode.NOADDONS) {
            IPacket<IServerPlayNetHandler> packet;
            IPacket<?> iPacket = event.packet;
            if (iPacket instanceof CChatMessagePacket) {
                packet = (CChatMessagePacket)iPacket;
                String message = ((CChatMessagePacket)packet).getMessage();
                if (message.startsWith(CHAT_COMMAND_CHAR) && message.substring(1).startsWith(CHAT_COMMAND_CHAR)) {
                    ((CChatMessagePacket)packet).message = message.substring(1);
                    return;
                }
                if (message.startsWith(CHAT_COMMAND_CHAR)) {
                    event.cancelled = true;
                    this.method30236();
                    String[] parts = message.substring(CHAT_COMMAND_CHAR.length()).split(" ");
                    Command command = this.getCommandByName(parts[0]);
                    if (command == null) {
                        this.invalidCommandMessage(parts[0]);
                        return;
                    }
                    ArrayList<ChatCommandArguments> args = new ArrayList<ChatCommandArguments>();
                    for (int i = 1; i < parts.length; ++i) {
                        args.add(new ChatCommandArguments(parts[i]));
                    }
                    MinecraftUtil.addChatMessage(" ");
                    try {
                        command.run(message, args.toArray(new ChatCommandArguments[0]), msg -> MinecraftUtil.addChatMessage(this.getPrefix() + " " + msg));
                    }
                    catch (CommandException exception) {
                        if (!exception.reason.isEmpty()) {
                            MinecraftUtil.addChatMessage(this.getPrefix() + " Error: " + exception.reason);
                        }
                        MinecraftUtil.addChatMessage(this.getPrefix() + " Usage: ." + command.getName() + " " + command.getOptions());
                    }
                    MinecraftUtil.addChatMessage(" ");
                }
            }
            if ((iPacket = event.packet) instanceof CTabCompletePacket && ((CTabCompletePacket)(packet = (CTabCompletePacket)iPacket)).getCommand().startsWith(CHAT_COMMAND_CHAR)) {
                event.cancelled = true;
            }
        }
    }
}

