/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.gui.impl.jello.ingame.clickgui;

import com.mentalfrostbyte.jello.gui.combined.AnimatedIconPanel;
import com.mentalfrostbyte.jello.gui.combined.CustomGuiScreen;
import com.mentalfrostbyte.jello.managers.AnimationManager;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil;
import com.mentalfrostbyte.jello.util.game.render.RenderUtil2;
import com.mentalfrostbyte.jello.util.system.math.RandomIntGenerator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class BrainFreezeOverlay
extends AnimatedIconPanel {
    private final List<ParticleEffect> particles = new ArrayList<ParticleEffect>();
    private final AnimationManager animationManager = new AnimationManager();
    public RandomIntGenerator random = new RandomIntGenerator();

    public BrainFreezeOverlay(CustomGuiScreen parentScreen, String name) {
        super(parentScreen, name, 0, 0, Minecraft.getInstance().getMainWindow().getWidth(), Minecraft.getInstance().getMainWindow().getHeight(), false);
        this.setFocused(false);
        this.setHovered(false);
        this.setReAddChildren(false);
        this.method13294(true);
        this.setListening(false);
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(false);
    }

    @Override
    public void updatePanelDimensions(int newHeight, int newWidth) {
        super.updatePanelDimensions(newHeight, newWidth);
    }

    @Override
    public void draw(float partialTicks) {
        int scaledWidth = Minecraft.getInstance().getMainWindow().getScaledWidth();
        int scaledHeight = Minecraft.getInstance().getMainWindow().getScaledHeight();
        int halfScreenWidth = scaledWidth / 2;
        boolean shouldUpdate = false;
        while (this.particles.size() < halfScreenWidth) {
            this.particles.add(new ParticleEffect(this.random.nextInt(scaledWidth), this.random.nextInt(scaledHeight)));
            shouldUpdate = true;
        }
        while (this.particles.size() > halfScreenWidth) {
            this.particles.remove(0);
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            for (ParticleEffect particle : this.particles) {
                particle.initialXPosition = this.random.nextInt(scaledWidth);
                particle.yPosition = this.random.nextInt(scaledHeight);
            }
        }
        this.animationManager.update();
        for (ParticleEffect particle : this.particles) {
            particle.updatePosition(this.animationManager);
            if (!(particle.initialXPosition < 0.0f)) {
                if (particle.initialXPosition > (float)scaledWidth) {
                    particle.initialXPosition = 0.0f;
                }
            } else {
                particle.initialXPosition = scaledWidth;
            }
            if (!(particle.yPosition < 0.0f)) {
                if (particle.yPosition > (float)scaledHeight) {
                    particle.yPosition = 0.0f;
                }
            } else {
                particle.yPosition = scaledHeight;
            }
            particle.render(partialTicks);
        }
        super.draw(partialTicks);
    }

    public static class ParticleEffect {
        private float xPosition;
        public float initialXPosition;
        public float yPosition;
        public float size;
        private float movementSpeed;
        private final RandomIntGenerator random = new RandomIntGenerator();
        public float direction;
        public Color color = new Color(1.0f, 1.0f, 1.0f, 0.5f);

        public ParticleEffect(float x, float y) {
            this.initialXPosition = this.xPosition = x;
            this.yPosition = y;
            this.size = (float)this.random.nextInt(1, 3) + this.random.nextFloat();
            this.initialize();
        }

        private void initialize() {
            float maxMovement = 1.0f;
            this.movementSpeed = this.random.nextFloat() % maxMovement;
            this.direction = this.random.nextFloat() / 2.0f;
            if (this.random.nextBoolean()) {
                this.direction *= -1.0f;
            }
        }

        public void render(float partialTicks) {
            RenderUtil.drawCircle(this.initialXPosition * 2.0f, this.yPosition * 2.0f, this.size * 2.0f, RenderUtil2.applyAlpha(this.color.getRGB(), partialTicks * 0.7f));
        }

        public void updatePosition(AnimationManager animationManager) {
            this.initialXPosition = this.initialXPosition + animationManager.getCurrentValue() + this.direction;
            this.xPosition = this.xPosition + animationManager.getCurrentValue() + this.direction;
            this.yPosition += this.movementSpeed;
        }
    }
}

