/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.gui.impl.jello.ingame.buttons.keybind;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mentalfrostbyte.Client;
import com.mentalfrostbyte.jello.gui.impl.jello.ingame.buttons.keybind.KeybindTypes;
import com.mentalfrostbyte.jello.module.Module;
import net.minecraft.client.gui.screen.Screen;

public class Bound {
    private int key = -1;
    private Object target;

    public Bound(JsonObject json) {
        this.loadFromJSON(json);
    }

    public Bound(int key, Module target) {
        this.key = key;
        this.target = target;
    }

    public Bound(int key, Class<? extends Screen> target) {
        this.key = key;
        this.target = target;
    }

    public void loadFromJSON(JsonObject from) {
        if (from.has("target")) {
            try {
                if (from.has("key")) {
                    this.key = from.get("key").getAsInt();
                }
                if (from.has("type")) {
                    String var4;
                    switch (var4 = from.get("type").getAsString()) {
                        case "mod": {
                            for (Module module : Client.getInstance().moduleManager.getModuleMap().values()) {
                                if (!from.get("target").getAsString().equals(module.getName())) continue;
                                this.target = module;
                            }
                        }
                        case "screen": {
                            Class<? extends Screen> screen = Client.getInstance().guiManager.method33477(from.get("target").getAsString());
                            if (screen == null) break;
                            this.target = screen;
                        }
                    }
                }
            }
            catch (JsonParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JsonObject getKeybindData() {
        JsonObject obj = new JsonObject();
        switch (this.getKeybindTypes()) {
            case MODULE: {
                obj.addProperty("type", "mod");
                obj.addProperty("target", ((Module)this.target).getName());
                break;
            }
            case SCREEN: {
                obj.addProperty("type", "screen");
                obj.addProperty("target", Client.getInstance().guiManager.getNameForTarget((Class)this.target));
            }
        }
        obj.addProperty("key", (Number)this.key);
        return obj;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public int getKeybind() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public KeybindTypes getKeybindTypes() {
        return !(this.target instanceof Module) ? KeybindTypes.SCREEN : KeybindTypes.MODULE;
    }

    public Object getTarget() {
        return this.target;
    }

    public Class<? extends Screen> getScreenTarget() {
        return (Class)this.target;
    }

    public Module getModuleTarget() {
        return (Module)this.target;
    }

    public boolean equals(Object to) {
        if (to != this) {
            if (to instanceof Bound) {
                Bound other = (Bound)to;
                return this.getTarget().equals(other.getTarget());
            }
            return false;
        }
        return true;
    }
}

