/*
 * Decompiled with CFR 0.152.
 */
package com.mentalfrostbyte.jello.gui.base.animations;

import java.util.Date;

public class Animation {
    public int duration;
    public int reverseDuration;
    public Direction direction = Direction.FORWARDS;
    public Date startTime;
    public Date reverseStartTime;

    public Animation(int duration, int reverseDuration) {
        this(duration, reverseDuration, Direction.FORWARDS);
    }

    public Animation(int duration, int reverseDuration, Direction direction) {
        this.duration = duration;
        this.reverseDuration = reverseDuration;
        this.startTime = new Date();
        this.reverseStartTime = new Date();
        this.changeDirection(direction);
    }

    public static float calculateProgressWithReverse(Date date, Date date2, float a, float a2) {
        return Math.max(0.0f, Math.min(1.0f, Math.min(a, (float)(new Date().getTime() - (date != null ? date.getTime() : new Date().getTime()))) / a * (1.0f - Math.min(a2, (float)(new Date().getTime() - (date2 != null ? date2.getTime() : new Date().getTime()))) / a2)));
    }

    public static float calculateProgress(Date date, float a) {
        return Math.max(0.0f, Math.min(1.0f, Math.min(a, (float)(new Date().getTime() - (date != null ? date.getTime() : new Date().getTime()))) / a));
    }

    public static float calculateProgressWithReverse(Date date, Date date2, float max) {
        return Animation.calculateProgressWithReverse(date, date2, max, max);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasTimeElapsed(Date time, float elapsed) {
        if (time == null) return false;
        Date date = new Date();
        if (!((float)(date.getTime() - time.getTime()) > elapsed)) return false;
        return true;
    }

    public int getDuration() {
        return this.duration;
    }

    public void changeDirection(Direction direction) {
        if (this.direction == direction) {
            return;
        }
        if (direction == Direction.FORWARDS) {
            this.startTime = new Date(new Date().getTime() - (long)(this.calcPercent() * (float)this.duration));
        } else {
            this.reverseStartTime = new Date(new Date().getTime() - (long)((1.0f - this.calcPercent()) * (float)this.reverseDuration));
        }
        this.direction = direction;
    }

    public void updateStartTime(float progress) {
        switch (this.direction.ordinal()) {
            case 1: {
                this.startTime = new Date(new Date().getTime() - (long)(progress * (float)this.duration));
                break;
            }
            case 2: {
                this.reverseStartTime = new Date(new Date().getTime() - (long)((1.0f - progress) * (float)this.reverseDuration));
            }
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public float calcPercent() {
        if (this.direction == Direction.BACKWARDS) {
            return Math.max(0.0f, 1.0f - Math.min(1.0f, (float)(new Date().getTime() - this.reverseStartTime.getTime()) / (float)this.reverseDuration));
        }
        return Math.min(1.0f, (float)(new Date().getTime() - this.startTime.getTime()) / (float)this.duration);
    }

    public static enum Direction {
        FORWARDS,
        BACKWARDS;

    }
}

