/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.p2.P2Artifact;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.PropertiesParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2MetadataParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;

    public P2MetadataParser(P2Descriptor p2Descriptor) {
        this.p2Descriptor = p2Descriptor;
    }

    public void parse(InputStream in) throws ParseException, IOException, SAXException {
        RepositoryHandler handler = new RepositoryHandler(this.p2Descriptor);
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    private static String namespace2Type(String namespace) {
        if (namespace.equals("java.package")) {
            return "package";
        }
        if (namespace.equals("osgi.bundle")) {
            return "bundle";
        }
        return null;
    }

    static class LifeCycleHandler
    extends AbstractRequirementHandler {
        private static final String LIFE_CYCLE = "lifeCycle";

        public LifeCycleHandler() {
            super(LIFE_CYCLE);
        }
    }

    static class ScopeHandler
    extends DelegetingHandler {
        private static final String SCOPE = "scope";

        public ScopeHandler() {
            super(SCOPE);
            this.addChild(new RequiresHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }
    }

    static class PatchScopeHandler
    extends DelegetingHandler {
        private static final String PATCH_SCOPE = "patchScope";

        public PatchScopeHandler() {
            super(PATCH_SCOPE);
            this.addChild(new PatchScopeHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
        }
    }

    static class ToHandler
    extends AbstractRequirementHandler {
        private static final String TO = "to";

        public ToHandler() {
            super(TO);
        }
    }

    static class FromHandler
    extends AbstractRequirementHandler {
        private static final String FROM = "from";

        public FromHandler() {
            super(FROM);
        }
    }

    static class ChangeHandler
    extends DelegetingHandler {
        private static final String CHANGE = "change";

        public ChangeHandler() {
            super(CHANGE);
        }
    }

    static class ChangesHandler
    extends DelegetingHandler {
        private static final String CHANGES = "changes";

        public ChangesHandler() {
            super(CHANGES);
            this.addChild(new ChangeHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
        }
    }

    static class ArtifactHandler
    extends DelegetingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String ID = "id";
        private static final String VERSION = "version";
        private static final String CLASSIFIER = "classifier";
        P2Artifact artifact;

        public ArtifactHandler() {
            super(ARTIFACT);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            String classifier = atts.getValue(CLASSIFIER);
            try {
                this.artifact = new P2Artifact(id, new Version(version), classifier);
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on artifact '" + id + "': " + version + " (" + e.getMessage() + ")");
            }
        }
    }

    static class ArtifactsHandler
    extends DelegetingHandler {
        private static final String ARTIFACTS = "artifacts";
        private static final String SIZE = "size";
        List artifacts;

        public ArtifactsHandler() {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    ArtifactsHandler.this.artifacts.add(((ArtifactHandler)child).artifact);
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.artifacts = new ArrayList(size);
        }
    }

    static class MetaRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String META_REQUIREMENTS = "metaRequirements";

        public MetaRequirementsHandler() {
            super(META_REQUIREMENTS);
        }
    }

    static class HostRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String HOST_REQUIREMENTS = "hostRequirements";

        public HostRequirementsHandler() {
            super(HOST_REQUIREMENTS);
        }
    }

    static class RequiredHandler
    extends DelegetingHandler {
        private static final String REQUIRED = "required";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String RANGE = "range";
        String namespace;
        String name;
        VersionRange range;
        String filter;

        public RequiredHandler() {
            super(REQUIRED);
            this.addChild(new FilterHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    RequiredHandler.this.filter = child.getBufferedChars().trim();
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            this.namespace = atts.getValue(NAMESPACE);
            this.name = atts.getValue(NAME);
            try {
                this.range = new VersionRange(atts.getValue(RANGE));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class RequiresHandler
    extends AbstractRequirementHandler {
        private static final String REQUIRES = "requires";

        public RequiresHandler() {
            super(REQUIRES);
        }
    }

    static abstract class AbstractRequirementHandler
    extends DelegetingHandler {
        private static final String SIZE = "size";
        List requirements;

        public AbstractRequirementHandler(String name) {
            super(name);
            this.addChild(new RequiredHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    String name = ((RequiredHandler)child).name;
                    VersionRange range = ((RequiredHandler)child).range;
                    String type = P2MetadataParser.namespace2Type(((RequiredHandler)child).namespace);
                    if (type == null) {
                        Message.debug("Unsupported required capability " + ((RequiredHandler)child).namespace + " " + name + " " + range);
                    } else {
                        AbstractRequirementHandler.this.requirements.add(new BundleRequirement(type, name, range, null));
                    }
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.requirements = new ArrayList(size);
        }
    }

    static class ProvidedHandler
    extends DelegetingHandler {
        private static final String PROVIDED = "provided";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String VERSION = "version";
        String namespace;
        String name;
        Version version;

        public ProvidedHandler() {
            super(PROVIDED);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.namespace = atts.getValue(NAMESPACE);
            this.name = atts.getValue(NAME);
            try {
                this.version = new Version(atts.getValue(VERSION));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on provided capability: " + this.version + " (" + e.getMessage() + ")");
            }
        }
    }

    static class ProvidesHandler
    extends DelegetingHandler {
        private static final String PROVIDES = "provides";
        private static final String SIZE = "size";
        List capabilities;

        public ProvidesHandler() {
            super(PROVIDES);
            this.addChild(new ProvidedHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    String name = ((ProvidedHandler)child).name;
                    Version version = ((ProvidedHandler)child).version;
                    String type = P2MetadataParser.namespace2Type(((ProvidedHandler)child).namespace);
                    if (type == null) {
                        Message.debug("Unsupported provided capability " + ((ProvidedHandler)child).namespace + " " + name + " " + version);
                        return;
                    }
                    BundleCapability capability = type == "package" ? new ExportPackage(name, version) : new BundleCapability(type, name, version);
                    ProvidesHandler.this.capabilities.add(capability);
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.capabilities = new ArrayList(size);
        }
    }

    static class FilterHandler
    extends DelegetingHandler {
        private static final String FILTER = "filter";

        public FilterHandler() {
            super(FILTER);
            this.setBufferingChar(true);
        }
    }

    static class UnitHandler
    extends DelegetingHandler {
        private static final String UNIT = "unit";
        private static final String ID = "id";
        private static final String VERSION = "version";
        BundleInfo bundleInfo;

        public UnitHandler() {
            super(UNIT);
            this.addChild(new PropertiesParser.PropertiesHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    Map properties = ((PropertiesParser.PropertiesHandler)child).properties;
                    String category = (String)properties.get("org.eclipse.equinox.p2.type.category");
                    if (category != null && Boolean.valueOf(category).booleanValue()) {
                        child.getParent().skip();
                    }
                }
            });
            this.addChild(new ProvidesHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    Iterator it = ((ProvidesHandler)child).capabilities.iterator();
                    while (it.hasNext()) {
                        UnitHandler.this.bundleInfo.addCapability((BundleCapability)it.next());
                    }
                }
            });
            this.addChild(new FilterHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
            this.addChild(new RequiresHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    Iterator it = ((RequiresHandler)child).requirements.iterator();
                    while (it.hasNext()) {
                        UnitHandler.this.bundleInfo.addRequirement((BundleRequirement)it.next());
                    }
                }
            });
            this.addChild(new HostRequirementsHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
            this.addChild(new MetaRequirementsHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
            this.addChild(new ArtifactsHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
            this.addChild(new ChangesHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            try {
                this.bundleInfo = new BundleInfo(id, new Version(version));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on bundle '" + id + "': " + version + " (" + e.getMessage() + ")");
            }
        }
    }

    static class UnitsHandler
    extends DelegetingHandler {
        private static final String UNITS = "units";
        private static final String SIZE = "size";
        List bundles;

        public UnitsHandler() {
            super(UNITS);
            this.addChild(new UnitHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    BundleInfo bundleInfo = ((UnitHandler)child).bundleInfo;
                    if (!bundleInfo.getCapabilities().isEmpty()) {
                        UnitsHandler.this.bundles.add(((UnitHandler)child).bundleInfo);
                    }
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.bundles = new ArrayList(size);
        }
    }

    static class RepositoryReferenceHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";
        private static final String TYPE = "type";
        private static final String OPTIONS = "options";
        private static final String NAME = "name";
        private static final String URI = "uri";
        private static final String URL = "url";
        int type;
        int options;
        String name;
        URI uri;

        public RepositoryReferenceHandler() {
            super(REPOSITORY);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.type = Integer.parseInt(atts.getValue(TYPE));
            this.options = Integer.parseInt(atts.getValue(OPTIONS));
            this.name = atts.getValue(NAME);
            try {
                String uriAtt = atts.getValue(URI);
                String url = atts.getValue(URL);
                if (this.uri != null) {
                    this.uri = new URI(uriAtt);
                } else if (url != null) {
                    this.uri = new URI(url);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    static class ReferencesHandler
    extends DelegetingHandler {
        private static final String REFERENCES = "references";
        private static final String SIZE = "size";
        List repositoryUris;

        public ReferencesHandler() {
            super(REFERENCES);
            this.addChild(new RepositoryReferenceHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    ReferencesHandler.this.repositoryUris.add(((RepositoryReferenceHandler)child).uri);
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.repositoryUris = new ArrayList(size);
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";

        public RepositoryHandler(final P2Descriptor p2Descriptor) {
            super(REPOSITORY);
            this.addChild(new PropertiesParser.PropertiesHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    Map properties = ((PropertiesParser.PropertiesHandler)child).properties;
                    String timestamp = (String)properties.get("p2.timestamp");
                    if (timestamp != null) {
                        p2Descriptor.setTimestamp(Long.parseLong(timestamp));
                    }
                }
            });
            this.addChild(new UnitsHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    Iterator it = ((UnitsHandler)child).bundles.iterator();
                    while (it.hasNext()) {
                        p2Descriptor.addBundle((BundleInfo)it.next());
                    }
                }
            });
            this.addChild(new ReferencesHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                }
            });
        }
    }
}

