/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmArrayVariableInLoopAssignmentChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isOuterForLoopRangeVariable", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend.java"})
public final class JvmArrayVariableInLoopAssignmentChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final JvmArrayVariableInLoopAssignmentChecker INSTANCE = new JvmArrayVariableInLoopAssignmentChecker();

    private JvmArrayVariableInLoopAssignmentChecker() {
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProperForInArrayLoopRangeVariableAssignmentSemantic)) {
            return;
        }
        KtBinaryExpression ktBinaryExpression = expression2 instanceof KtBinaryExpression ? (KtBinaryExpression)expression2 : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) {
            return;
        }
        KtExpression ktExpression = binaryExpression.getLeft();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhsExpression = ktSimpleNameExpression;
        KtElement ktElement = lhsExpression;
        BindingContext bindingContext = c.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"c.trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        LocalVariableDescriptor localVariableDescriptor = callableDescriptor instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)callableDescriptor : null;
        if (localVariableDescriptor == null) {
            return;
        }
        LocalVariableDescriptor variableDescriptor = localVariableDescriptor;
        if (variableDescriptor instanceof SyntheticFieldDescriptor) {
            return;
        }
        if (variableDescriptor.isDelegated()) {
            return;
        }
        KotlinType kotlinType = variableDescriptor.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"variableDescriptor.returnType");
        KotlinType variableType = kotlinType;
        if (!KotlinBuiltIns.isArrayOrPrimitiveArray(variableType)) {
            return;
        }
        if (!this.isOuterForLoopRangeVariable(expression2, variableDescriptor, c)) {
            return;
        }
        DataFlowValue.Kind dataFlowValueKind = c.dataFlowValueFactory.createDataFlowValue(lhsExpression, variableType, c).getKind();
        if (dataFlowValueKind != DataFlowValue.Kind.STABLE_VARIABLE) {
            return;
        }
        c.trace.report(ErrorsJvm.ASSIGNMENT_TO_ARRAY_LOOP_VARIABLE.on((KtExpression)((PsiElement)lhsExpression)));
    }

    private final boolean isOuterForLoopRangeVariable(KtExpression expression2, CallableDescriptor variableDescriptor, ResolutionContext<?> c) {
        for (PsiElement parent2 : PsiUtilsKt.getParents(expression2)) {
            ResolvedCall<? extends CallableDescriptor> rangeResolvedCall;
            KtSimpleNameExpression rangeExpression;
            KtExpression ktExpression;
            if (!(parent2 instanceof KtForExpression) || ((ktExpression = ((KtForExpression)parent2).getLoopRange()) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null) == null) continue;
            rangeExpression = rangeExpression;
            KtElement ktElement = rangeExpression;
            BindingContext bindingContext = c.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"c.trace.bindingContext");
            if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null || !Intrinsics.areEqual((Object)rangeResolvedCall.getResultingDescriptor(), (Object)variableDescriptor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        AdditionalTypeChecker.DefaultImpls.checkReceiver(this, receiverParameter, receiverArgument, safeAccess, c);
    }
}

