/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/DoWhileGuardElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "guardLabels", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "guardToLoopLabel", "", "hasChanges", "", "loopGuardMap", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "analyze", "", "apply", "findBreakInNestedLoop", "statement", "name", "perform", "js.translator"})
public final class DoWhileGuardElimination {
    @NotNull
    private final JsStatement root;
    @NotNull
    private final Set<JsName> guardLabels;
    private boolean hasChanges;
    @NotNull
    private final Map<JsDoWhile, JsLabel> loopGuardMap;
    @NotNull
    private final Map<JsName, JsName> guardToLoopLabel;

    public DoWhileGuardElimination(@NotNull JsStatement root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.root = root2;
        this.guardLabels = new LinkedHashSet();
        this.loopGuardMap = new LinkedHashMap();
        this.guardToLoopLabel = new LinkedHashMap();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            final /* synthetic */ DoWhileGuardElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement statement2 = x.getStatement();
                if (statement2 instanceof JsDoWhile) {
                    this.processDoWhile((JsDoWhile)statement2, x.getName());
                } else {
                    super.visitLabel(x);
                }
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.processDoWhile(x, null);
            }

            private final void processDoWhile(JsDoWhile x, JsName label) {
                JsStatement body2;
                block5: {
                    JsLabel guard;
                    Object object;
                    block6: {
                        JsLabel jsLabel;
                        body2 = x.getBody();
                        object = body2;
                        if (object instanceof JsBlock) {
                            List<JsStatement> list2 = ((JsBlock)body2).getStatements();
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"body.statements");
                            JsStatement firstStatement = (JsStatement)CollectionsKt.firstOrNull(list2);
                            jsLabel = firstStatement instanceof JsLabel && ((JsBlock)body2).getStatements().size() == 1 ? (JsLabel)firstStatement : (JsLabel)null;
                        } else {
                            jsLabel = guard = object instanceof JsLabel ? (JsLabel)body2 : null;
                        }
                        if (guard == null) break block5;
                        if (label != null) break block6;
                        JsStatement jsStatement = guard;
                        JsName jsName = guard.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"guard.name");
                        if (DoWhileGuardElimination.access$findBreakInNestedLoop(this.this$0, jsStatement, jsName)) break block5;
                    }
                    ((Collection)DoWhileGuardElimination.access$getGuardLabels$p(this.this$0)).add(guard.getName());
                    DoWhileGuardElimination.access$getLoopGuardMap$p(this.this$0).put(x, guard);
                    object = DoWhileGuardElimination.access$getGuardToLoopLabel$p(this.this$0);
                    JsName jsName = guard.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"guard.name");
                    object.put(jsName, label);
                }
                body2.accept(this);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
        }.accept((JsNode)this.root);
    }

    private final boolean findBreakInNestedLoop(JsStatement statement2, JsName name) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        statement2.accept(new RecursiveJsVisitor(name, result2){
            private int loopLevel;
            final /* synthetic */ JsName $name;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$name = $name;
                this.$result = $result;
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                HasMetadata hasMetadata = x.getLabel();
                if (hasMetadata == null || (hasMetadata = hasMetadata.getName()) == null) {
                    return;
                }
                HasMetadata guardLabel = hasMetadata;
                if (Intrinsics.areEqual((Object)guardLabel, (Object)this.$name) && this.isInLoop()) {
                    this.$result.element = true;
                }
            }

            private final boolean isInLoop() {
                return this.loopLevel > 0;
            }

            public void visitLoop(@NotNull JsLoop x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.loopLevel;
                this.loopLevel = n + 1;
                super.visitLoop(x);
                n = this.loopLevel;
                this.loopLevel = n + -1;
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!this.$result.element) {
                    super.visitElement(node);
                }
            }
        });
        return result2.element;
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ DoWhileGuardElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(@NotNull JsDoWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsLabel jsLabel = (JsLabel)DoWhileGuardElimination.access$getLoopGuardMap$p(this.this$0).get(x);
                if (jsLabel != null) {
                    JsLabel jsLabel2 = jsLabel;
                    DoWhileGuardElimination doWhileGuardElimination = this.this$0;
                    JsLabel guard = jsLabel2;
                    boolean bl = false;
                    if (DoWhileGuardElimination.access$getGuardLabels$p(doWhileGuardElimination).contains(guard.getName())) {
                        x.setBody((JsStatement)this.accept((JsNode)guard.getStatement()));
                        DoWhileGuardElimination.access$setHasChanges$p(doWhileGuardElimination, true);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsBreak x, @NotNull JsContext<JsNode> ctx) {
                JsName name;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = name = jsNameRef != null ? jsNameRef.getName() : null;
                if (CollectionsKt.contains((Iterable)DoWhileGuardElimination.access$getGuardLabels$p(this.this$0), (Object)name)) {
                    JsName target;
                    JsName jsName2 = target = (JsName)DoWhileGuardElimination.access$getGuardToLoopLabel$p(this.this$0).get(name);
                    ctx.replaceMe((JsNode)new JsContinue(jsName2 != null ? jsName2.makeRef() : null));
                    DoWhileGuardElimination.access$setHasChanges$p(this.this$0, true);
                }
                return false;
            }
        }.accept((JsNode)this.root);
    }

    public static final /* synthetic */ boolean access$findBreakInNestedLoop(DoWhileGuardElimination $this, JsStatement statement2, JsName name) {
        return $this.findBreakInNestedLoop(statement2, name);
    }

    public static final /* synthetic */ Set access$getGuardLabels$p(DoWhileGuardElimination $this) {
        return $this.guardLabels;
    }

    public static final /* synthetic */ Map access$getLoopGuardMap$p(DoWhileGuardElimination $this) {
        return $this.loopGuardMap;
    }

    public static final /* synthetic */ Map access$getGuardToLoopLabel$p(DoWhileGuardElimination $this) {
        return $this.guardToLoopLabel;
    }

    public static final /* synthetic */ void access$setHasChanges$p(DoWhileGuardElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

