/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirTopLevelPropertiesCheckerKt;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.declarations.FirProperty;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTopLevelPropertiesChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirTopLevelPropertiesChecker INSTANCE = new FirTopLevelPropertiesChecker();

    private FirTopLevelPropertiesChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (context2.getContainingDeclarations().size() > 1) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        FirModifierList modifierList2 = FirKeywordUtilsKt.getModifierList(source);
        boolean $i$f$withSuppressedDiagnostics = false;
        List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(declaration2);
        if (arguments$iv != null) {
            DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            if (diagnosticContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
            }
            CheckerContext it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
            boolean bl = false;
            FirTopLevelPropertiesCheckerKt.checkPropertyInitializer$default(null, declaration2, modifierList2, declaration2.getInitializer() != null, reporter, context2, false, 64, null);
            FirTopLevelPropertiesCheckerKt.checkExpectDeclarationVisibilityAndBody(declaration2, source, reporter, context2);
        } else {
            CheckerContext it = (CheckerContext)((MutableDiagnosticContext)context2);
            boolean bl = false;
            FirTopLevelPropertiesCheckerKt.checkPropertyInitializer$default(null, declaration2, modifierList2, declaration2.getInitializer() != null, reporter, context2, false, 64, null);
            FirTopLevelPropertiesCheckerKt.checkExpectDeclarationVisibilityAndBody(declaration2, source, reporter, context2);
        }
    }
}

