/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskpath;

import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.internal.NameMatcher;

public class ProjectFinderByTaskPath {
    private static final Logger LOGGER = Logging.getLogger(ProjectFinderByTaskPath.class);

    public ProjectInternal findProject(String projectPath, ProjectInternal startProject) throws ProjectLookupException {
        String[] components;
        MatchedProject matchedProject;
        String originalProjectPath = projectPath;
        if (projectPath.startsWith(":")) {
            matchedProject = new MatchedProject(startProject.getRootProject(), false);
            projectPath = projectPath.substring(1);
        } else {
            matchedProject = new MatchedProject(startProject, false);
        }
        for (String component : components = projectPath.split(":")) {
            if (component.isEmpty()) continue;
            matchedProject = this.resolveProject(component, matchedProject);
        }
        if (matchedProject.isPatternMatched()) {
            LOGGER.info("Abbreviated project name '{}' matched '{}'", (Object)originalProjectPath, (Object)matchedProject.getProject().getPath());
        } else {
            LOGGER.info("Project name matched '{}'", (Object)matchedProject.getProject().getPath());
        }
        return (ProjectInternal)matchedProject.getProject();
    }

    private MatchedProject resolveProject(String projectName, MatchedProject parentProjectMatch) throws ProjectLookupException {
        Project parentProject = parentProjectMatch.getProject();
        Map childProjects = parentProject.getChildProjects();
        if (childProjects.containsKey(projectName)) {
            return new MatchedProject((Project)childProjects.get(projectName), parentProjectMatch.isPatternMatched());
        }
        NameMatcher matcher = new NameMatcher();
        Project foundProject = (Project)matcher.find(projectName, childProjects);
        if (foundProject != null) {
            return new MatchedProject(foundProject, true);
        }
        throw new ProjectLookupException(matcher.formatErrorMessage("project", parentProject));
    }

    private static class MatchedProject {
        private final Project project;
        private final boolean patternMatched;

        public MatchedProject(Project project, boolean patternMatched) {
            this.project = project;
            this.patternMatched = patternMatched;
        }

        public Project getProject() {
            return this.project;
        }

        public boolean isPatternMatched() {
            return this.patternMatched;
        }
    }

    public static class ProjectLookupException
    extends InvalidUserDataException {
        public ProjectLookupException(String message) {
            super(message);
        }
    }
}

