/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class EnumProperty<T extends Enum<T>>
extends AbstractProperty<T> {
    private final Set<T> allowedValues;

    EnumProperty(T defaultValue, Set<T> allowedValues) {
        super(defaultValue, (UnmodifiableConfig config, List<String> path) -> config.getEnumOrElse(path, defaultValue));
        this.allowedValues = ImmutableSet.copyOf(allowedValues);
    }

    @Override
    public void defineSpec(ConfigSpec spec) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        spec.defineRestrictedEnum(this.data.getPath(), (Enum)this.defaultValue, this.allowedValues, EnumGetMethod.NAME_IGNORECASE);
    }

    @Override
    public boolean isValid(T value) {
        return value != null && this.allowedValues.contains(value);
    }

    public Set<T> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public String getAllowedValuesString() {
        return "Valid values: " + String.join((CharSequence)", ", this.allowedValues.stream().map(Enum::name).toList());
    }

    public static <T extends Enum<T>> EnumProperty<T> create(T defaultValue) {
        return EnumProperty.create(defaultValue, new LinkedHashSet<Enum>(List.of((Enum[])defaultValue.getDeclaringClass().getEnumConstants())));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(T defaultValue, Set<T> allowedValues) {
        return new EnumProperty<T>(defaultValue, allowedValues);
    }
}

