/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.ModSoundType;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PlanterBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.forge.FarmersDelightCompatImpl;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;

public class FarmersDelightCompat {
    public static final ModSoundType STICK_TOMATO_SOUND = new ModSoundType(1.0f, 1.0f, () -> SoundEvents.f_11838_, () -> SoundEvents.f_11992_, () -> SoundEvents.f_12635_, () -> SoundEvents.f_11990_, () -> SoundEvents.f_11989_);
    public static final Supplier<Block> ROPE_TOMATO = RegHelper.registerBlock((ResourceLocation)Supplementaries.res("rope_tomatoes"), () -> new TomatoRopeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_280574_()));
    public static final Supplier<Block> STICK_TOMATOES = RegHelper.registerBlock((ResourceLocation)Supplementaries.res("stick_tomatoes"), () -> new TomatoStickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_280574_().m_60918_((SoundType)STICK_TOMATO_SOUND)));

    public static void init() {
    }

    @Nullable
    public static BlockState getTomatoLoggedReplacement(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (FarmersDelightCompat.isTomatoVineClimbingConfigOn()) {
            if (state.m_60713_((Block)ModRegistry.ROPE.get())) {
                BlockState toPlace = ROPE_TOMATO.get().m_49966_();
                toPlace = Block.m_49931_((BlockState)toPlace, (LevelAccessor)level, (BlockPos)pos);
                return toPlace;
            }
            if (state.m_60713_(ModRegistry.STICK_BLOCK.get())) {
                BlockState toPlace = STICK_TOMATOES.get().m_49966_();
                return toPlace;
            }
        }
        return null;
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isTomatoVineClimbingConfigOn() {
        return FarmersDelightCompatImpl.isTomatoVineClimbingConfigOn();
    }

    public static Block getStickTomato() {
        return STICK_TOMATOES.get();
    }

    public static void setupClient() {
        ClientHelper.registerRenderType((Block)ROPE_TOMATO.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)STICK_TOMATOES.get(), (RenderType)RenderType.m_110463_());
    }

    public static boolean canAddStickToTomato(BlockState blockstate, BooleanProperty axis) {
        if (blockstate.m_60734_() == FarmersDelightCompat.getStickTomato()) {
            return (Boolean)blockstate.m_61143_((Property)axis) == false;
        }
        return false;
    }

    public static PlanterBlock makePlanterRich() {
        return new PlanterRichBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50301_).m_60913_(2.0f, 6.0f).m_60999_().m_60977_(), CompatObjects.RICH_SOIL);
    }

    public static class PlanterRichBlock
    extends PlanterBlock {
        private final Supplier<BlockState> richSoilDelegate = Suppliers.memoize(() -> ((Block)mimic.get()).m_49966_());

        public PlanterRichBlock(BlockBehaviour.Properties properties, Supplier<Block> mimic) {
            super(properties);
            this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
        }

        public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
            return super.m_49635_(blockState, builder);
        }

        public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
            if (CommonConfigs.Building.FD_PLANTER.get().booleanValue()) {
                this.richSoilDelegate.get().m_222972_(worldIn, pos, rand);
            }
        }
    }

    private static class TomatoStickBlock
    extends TomatoLoggedBlock {
        public static final BooleanProperty AXIS_X = ModBlockProperties.AXIS_X;
        public static final BooleanProperty AXIS_Z = ModBlockProperties.AXIS_Z;

        public TomatoStickBlock(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(false)));
        }

        public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return StickBlock.getStickShape((Boolean)state.m_61143_((Property)AXIS_X), true, (Boolean)state.m_61143_((Property)AXIS_Z));
        }

        @Override
        public Block getInnerBlock() {
            return ModRegistry.STICK_BLOCK.get();
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{AXIS_X, AXIS_Z});
            super.m_7926_(builder);
        }

        public boolean m_6864_(BlockState state, BlockPlaceContext context) {
            if (!context.m_7078_() && context.m_43722_().m_150930_(Items.f_42398_)) {
                return switch (context.m_43719_().m_122434_()) {
                    case Direction.Axis.Z -> {
                        if (!((Boolean)state.m_61143_((Property)AXIS_Z)).booleanValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.Axis.X -> {
                        if (!((Boolean)state.m_61143_((Property)AXIS_X)).booleanValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
            return super.m_6864_(state, context);
        }
    }

    private static class TomatoRopeBlock
    extends TomatoLoggedBlock
    implements IRopeConnection {
        public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
        public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
        public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
        public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
        public static final BooleanProperty KNOT = ModBlockProperties.KNOT;

        public TomatoRopeBlock(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public Block getInnerBlock() {
            return (Block)ModRegistry.ROPE.get();
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, KNOT});
            super.m_7926_(builder);
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return state;
            }
            BlockState newState = (BlockState)state.m_61124_((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.shouldConnectToFace(state, facingState, facingPos, facing, (LevelReader)level)));
            boolean hasKnot = (Boolean)newState.m_61143_((Property)SOUTH) != false || (Boolean)newState.m_61143_((Property)EAST) != false || (Boolean)newState.m_61143_((Property)NORTH) != false || (Boolean)newState.m_61143_((Property)WEST) != false;
            newState = (BlockState)newState.m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(hasKnot));
            return newState;
        }

        @Override
        public boolean canSideAcceptConnection(BlockState state, Direction direction) {
            return true;
        }
    }

    private static abstract class TomatoLoggedBlock
    extends TomatoVineBlock {
        public TomatoLoggedBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public void attemptRopeClimb(ServerLevel level, BlockPos pos, RandomSource random) {
            super.attemptRopeClimb(level, pos, random);
        }

        public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            return (belowState.m_60734_() instanceof TomatoVineBlock || super.m_7898_((BlockState)state.m_61124_((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(false)), level, pos)) && this.hasGoodCropConditions(level, pos);
        }

        public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
            super.m_6240_(level, player, pos, (BlockState)state.m_61124_((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(false)), blockEntity, stack);
        }

        public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
            this.m_5707_(level, pos, state, player);
            return level.m_7731_(pos, this.getInnerBlock().m_152465_(state), level.f_46443_ ? 11 : 3);
        }

        public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
            if (!state.m_60710_((LevelReader)level, pos)) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, null, (ItemStack)ItemStack.f_41583_);
                level.m_46597_(pos, this.getInnerBlock().m_152465_(state));
            }
        }

        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            if (!state.m_60710_((LevelReader)level, currentPos)) {
                level.m_186460_(currentPos, (Block)this, 1);
            }
            return state;
        }

        public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
            state = CompatObjects.TOMATO_CROP.get().m_152465_(state);
            return state.m_287290_(builder);
        }

        public abstract Block getInnerBlock();
    }
}

