/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesGenerator
extends DynServerResourcesGenerator {
    public static final ServerDynamicResourcesGenerator INSTANCE = new ServerDynamicResourcesGenerator();
    private IRecipeTemplate<?> signPostTemplate2;

    public ServerDynamicResourcesGenerator() {
        super(new DynamicDataPack(Supplementaries.res("generated_pack")));
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        if (CommonConfigs.Building.SIGN_POST_ENABLED.get().booleanValue()) {
            executor.accept(this::addSignPostRecipes);
        }
        executor.accept((manager, sink) -> {
            SimpleTagBuilder builder = SimpleTagBuilder.of((ResourceLocation)Supplementaries.res("sign_posts"));
            builder.addEntries(ModRegistry.SIGN_POST_ITEMS.values());
            sink.addTag(builder, Registries.f_256913_);
            if (PlatHelper.getPlatform().isForge()) {
                builder = SimpleTagBuilder.of(ModTags.HAS_WAY_SIGNS);
                if (CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue() && CommonConfigs.Building.SIGN_POST_ENABLED.get().booleanValue()) {
                    builder.addTag(BiomeTags.f_215817_);
                }
                sink.addTag(builder, Registries.f_256952_);
                builder = SimpleTagBuilder.of(ModTags.HAS_CAVE_URNS);
                if (CommonConfigs.Functional.URN_PILE_ENABLED.get().booleanValue() && CommonConfigs.Functional.URN_ENABLED.get().booleanValue()) {
                    builder.addTag(BiomeTags.f_215817_);
                }
                sink.addTag(builder, Registries.f_256952_);
                builder = SimpleTagBuilder.of(ModTags.HAS_WILD_FLAX);
                if (CommonConfigs.Functional.WILD_FLAX_ENABLED.get().booleanValue()) {
                    builder.addTag(BiomeTags.f_215817_);
                }
                sink.addTag(builder, Registries.f_256952_);
                builder = SimpleTagBuilder.of(ModTags.HAS_BASALT_ASH);
                if (CommonConfigs.Building.BASALT_ASH_ENABLED.get().booleanValue()) {
                    builder.add(Biomes.f_48175_.m_135782_());
                    builder.m_215905_(new ResourceLocation("incendium:volcanic_deltas"));
                }
                sink.addTag(builder, Registries.f_256952_);
            }
        });
    }

    private void addSignPostRecipes(ResourceManager manager, ResourceSink sink) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(Supplementaries.res("sign_post_oak")));
        WoodType oak = WoodTypeRegistry.OAK_TYPE;
        if (this.signPostTemplate2 == null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(oak)), (int)3).m_126130_("   ").m_126130_("222").m_126130_(" 1 ").m_126127_(Character.valueOf('1'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('2'), (ItemLike)oak.planks).m_126145_("sign_post").m_126132_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{oak.planks})).m_176498_(s -> {
                this.signPostTemplate2 = TemplateRecipeManager.read((JsonObject)s.m_125966_());
            });
        }
        ModRegistry.SIGN_POST_ITEMS.forEach((w, i) -> {
            if (w != oak) {
                try {
                    IRecipeTemplate<?> recipeTemplate = w.getChild("sign") == null ? this.signPostTemplate2 : template;
                    FinishedRecipe newR = recipeTemplate.createSimilar((BlockType)WoodTypeRegistry.OAK_TYPE, (BlockType)w, w.mainChild().m_5456_());
                    if (newR == null) {
                        return;
                    }
                    newR = ForgeHelper.addRecipeConditions((FinishedRecipe)newR, (List)template.getConditions());
                    sink.addRecipe(newR);
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("Failed to generate recipe for sign post {}:", (Object)i, (Object)e);
                }
            }
        });
    }

    public void genAllRecipesAdv(String modId, ResourceSink sink) {
    }

    private static void removeNullEntries(JsonObject jsonObject) {
        jsonObject.entrySet().removeIf(entry -> ((JsonElement)entry.getValue()).isJsonNull());
        jsonObject.entrySet().forEach(entry -> {
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonObject()) {
                ServerDynamicResourcesGenerator.removeNullEntries(element.getAsJsonObject());
            } else if (element.isJsonArray()) {
                ServerDynamicResourcesGenerator.removeNullEntries(element.getAsJsonArray());
            }
        });
    }

    private static void removeNullEntries(JsonArray jsonArray) {
        JsonArray newArray = new JsonArray();
        jsonArray.forEach(element -> {
            if (!element.isJsonNull()) {
                if (element.isJsonObject()) {
                    ServerDynamicResourcesGenerator.removeNullEntries(element.getAsJsonObject());
                } else if (element.isJsonArray()) {
                    ServerDynamicResourcesGenerator.removeNullEntries(element.getAsJsonArray());
                }
                newArray.add(element);
            }
        });
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonArray.remove(i);
        }
        jsonArray.addAll(newArray);
    }
}

