/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.BlockPlacerItem;
import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.utils.forge.ItemsUtilImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ItemsUtil {
    @Nullable
    public static BlockState getPlacementState(BlockPlaceContext context, Block block) {
        return BlockPlacerItem.get().mimicGetPlacementState(context, block);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace) {
        return ItemsUtil.place(context, blockToPlace, null);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace, @Nullable SoundType placeSound) {
        return BlockPlacerItem.get().mimicPlace(context, blockToPlace, placeSound);
    }

    public static InteractionResult place(Item item, BlockPlaceContext pContext) {
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            return bi.m_40576_(pContext);
        }
        AdditionalItemPlacement placement = AdditionalItemPlacementsAPI.getBehavior((Item)item);
        if (placement != null) {
            return placement.overridePlace(pContext);
        }
        return InteractionResult.PASS;
    }

    public static void addStackToExisting(Player player, ItemStack stack, boolean avoidHands) {
        int j;
        Inventory inv = player.m_150109_();
        boolean added = false;
        for (j = 0; j < inv.f_35974_.size(); ++j) {
            if (!inv.m_8020_(j).m_150930_(stack.m_41720_()) || !inv.m_36040_(j, stack)) continue;
            added = true;
            break;
        }
        if (avoidHands && !added) {
            for (j = 0; j < inv.f_35974_.size(); ++j) {
                if (!inv.m_8020_(j).m_41619_() || j == inv.f_35977_ || !inv.m_36040_(j, stack)) continue;
                added = true;
                break;
            }
        }
        if (!added && inv.m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public static boolean tryInteractingWithContainerItem(ItemStack containerStack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean inSlot) {
        if (action != ClickAction.PRIMARY) {
            if (incoming.m_41619_()) {
                if (!inSlot) {
                    return ItemsUtil.extractFromContainerItemIntoSlot(player, containerStack, slot);
                }
            } else if (ItemsUtil.addToContainerItem(player, containerStack, incoming, slot, true, inSlot)) {
                return ItemsUtil.addToContainerItem(player, containerStack, incoming, slot, false, inSlot);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean addToContainerItem(Player player, ItemStack containerStack, ItemStack stack, Slot slot, boolean simulate, boolean inSlot) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.addToContainerItem(player, (ItemStack)var1_1, (ItemStack)var2_2, (Slot)var3_3, (boolean)var4_4, (boolean)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean extractFromContainerItemIntoSlot(Player player, ItemStack containerStack, Slot slot) {
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.extractFromContainerItemIntoSlot(player, (ItemStack)var1_1, (Slot)var2_2);
    }

    @Nullable
    public static BlockEntity loadBlockEntityFromItem(CompoundTag tag, Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity te = entityBlock.m_142194_(BlockPos.f_121853_, block.m_49966_());
            if (te != null) {
                te.m_142466_(tag);
            }
            return te;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static float getEncumbermentFromInventory(ItemStack stack, ServerPlayer player) {
        void var1_1;
        return ItemsUtilImpl.getEncumbermentFromInventory(stack, (ServerPlayer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IKeyLockable.KeyStatus hasKeyInInventory(Player player, String key) {
        void var1_1;
        return ItemsUtilImpl.hasKeyInInventory(player, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack tryExtractingItem(Level level, @Nullable Direction dir, Object container) {
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.tryExtractingItem(level, (Direction)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack tryAddingItem(ItemStack stack, Level level, @Nullable Direction direction, Object container) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.tryAddingItem(stack, (Level)var1_1, (Direction)var2_2, var3_3);
    }

    public static void addShulkerLikeTooltips(CompoundTag blockEntityTag, List<Component> tooltip) {
        if (blockEntityTag.m_128425_("LootTable", 8)) {
            tooltip.add((Component)Component.m_237113_((String)"???????").m_130940_(ChatFormatting.GRAY));
        }
        if (blockEntityTag.m_128425_("Items", 9)) {
            NonNullList itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)blockEntityTag, (NonNullList)itemStacks);
            int i = 0;
            int j = 0;
            for (ItemStack itemstack : itemStacks) {
                if (itemstack.m_41619_()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                MutableComponent component = itemstack.m_41786_().m_6881_();
                component.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                tooltip.add((Component)component.m_130940_(ChatFormatting.GRAY));
            }
            if (j - i > 0) {
                tooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

