/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FlagBlockTile
extends BlockEntity
implements Nameable,
IColored {
    public final float offset;
    @Nullable
    private Component name;
    private final DyeColor baseColor;
    @Nullable
    private ListTag itemPatterns;
    @Nullable
    private List<Pair<Holder<BannerPattern>, DyeColor>> patterns;

    public FlagBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, ((IColored)state.m_60734_()).getColor());
    }

    public FlagBlockTile(BlockPos pos, BlockState state, DyeColor color) {
        super(ModRegistry.FLAG_TILE.get(), pos, state);
        this.baseColor = color;
        this.offset = 3.0f * (Mth.m_14031_((float)this.f_58858_.m_123341_()) + Mth.m_14031_((float)this.f_58858_.m_123343_()));
    }

    public void setCustomName(Component component) {
        this.name = component;
    }

    public List<Pair<Holder<BannerPattern>, DyeColor>> getPatterns() {
        if (this.patterns == null) {
            this.patterns = BannerBlockEntity.m_58484_((DyeColor)this.baseColor, (ListTag)this.itemPatterns);
        }
        return this.patterns;
    }

    public ItemStack getItem(BlockState state) {
        ItemStack itemstack = new ItemStack((ItemLike)ModRegistry.FLAGS.get(this.baseColor).get());
        if (this.itemPatterns != null && !this.itemPatterns.isEmpty()) {
            itemstack.m_41698_("BlockEntityTag").m_128365_("Patterns", (Tag)this.itemPatterns.m_6426_());
        }
        if (this.name != null) {
            itemstack.m_41714_(this.name);
        }
        return itemstack;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.itemPatterns != null) {
            compound.m_128365_("Patterns", (Tag)this.itemPatterns);
        }
        if (this.name != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        if (compoundNBT.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)compoundNBT.m_128461_("CustomName"));
        }
        this.itemPatterns = compoundNBT.m_128437_("Patterns", 10);
        this.patterns = null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public AABB getRenderBoundingBox() {
        Direction dir = this.getDirection();
        return new AABB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).m_82363_((double)((float)dir.m_122429_() * 1.35f), 0.0, (double)((float)dir.m_122431_() * 1.35f)).m_82338_(this.f_58858_);
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)FlagBlock.FACING);
    }

    public Component m_7755_() {
        return this.name != null ? this.name : Component.m_237115_((String)("block.supplementaries.flag_" + this.baseColor.m_41065_()));
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    @Nullable
    public DyeColor getColor() {
        return this.baseColor;
    }
}

