/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.IRangedWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.entity.VehicleFuelInformation;
import ad_astra_giselle_addon.common.entity.VehicleHelper;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import ad_astra_giselle_addon.common.item.ItemStackUtils;
import ad_astra_giselle_addon.common.menu.FuelLoaderMenu;
import ad_astra_giselle_addon.common.world.ContainerHelper;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class FuelLoaderBlockEntity
extends ContainerMachineBlockEntity
implements BotariumFluidBlock<WrappedBlockFluidContainer>,
IRangedWorkingAreaBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_FLUID));
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final int[] FLUID_SOURCE_SLOTS = new int[]{0};
    public static final int[] FLUID_SINK_SLOTS = new int[]{1};
    public static final int[] FLUID_SLOTS = ArrayUtils.addAll((int[])FLUID_SOURCE_SLOTS, (int[])FLUID_SINK_SLOTS);
    public static final int CONTAINER_SIZE = FLUID_SLOTS.length;
    private boolean workingAreaVisible;
    private WrappedBlockFluidContainer fluidTank;

    public static List<TagKey<Fluid>> getFluidTags() {
        ArrayList<TagKey<Fluid>> list = new ArrayList<TagKey<Fluid>>();
        list.add(ModFluidTags.TIER_1_ROVER_FUEL);
        Rocket.ROCKET_TO_PROPERTIES.values().stream().map(i -> i.fuel()).forEach(list::add);
        return list;
    }

    public static boolean isFuel(FluidHolder fluidHolder) {
        return FuelLoaderBlockEntity.isFuel(fluidHolder.getFluid());
    }

    public static boolean isFuel(Fluid fluid) {
        return FuelLoaderBlockEntity.getFluidTags().stream().anyMatch(tag -> FluidPredicates.hasTag(fluid, (TagKey<Fluid>)tag));
    }

    public FuelLoaderBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, CONTAINER_SIZE);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.workingAreaVisible = tag.m_128471_(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FuelLoaderMenu(windowId, inv, this);
    }

    public WrappedBlockFluidContainer getFluidContainer() {
        if (this.fluidTank == null) {
            this.fluidTank = new WrappedBlockFluidContainer((BlockEntity)this, (FluidContainer)new SimpleFluidContainer(tank -> FluidConstants.fromMillibuckets((long)MachinesConfig.FUEL_LOADER_FLUID_CAPACITY), 1, (tank, fluid) -> FuelLoaderBlockEntity.isFuel(fluid)));
        }
        return this.fluidTank;
    }

    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        super.tickSideInteractions(pos, filter, sideConfig);
        TransferUtils.pushItemsNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (int[])FLUID_SOURCE_SLOTS, (ConfigurationEntry)sideConfig.get(0), filter);
        TransferUtils.pullItemsNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (int[])FLUID_SOURCE_SLOTS, (ConfigurationEntry)sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (int[])FLUID_SINK_SLOTS, (ConfigurationEntry)sideConfig.get(1), filter);
        TransferUtils.pullItemsNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (int[])FLUID_SINK_SLOTS, (ConfigurationEntry)sideConfig.get(1), filter);
        WrappedBlockFluidContainer fluidContainer = this.getFluidContainer();
        long fluidCapacity = FluidConstants.fromMillibuckets((long)MachinesConfig.FUEL_LOADER_FLUID_CAPACITY);
        TransferUtils.pushFluidNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (WrappedBlockFluidContainer)fluidContainer, (long)fluidCapacity, (int)0, (ConfigurationEntry)sideConfig.get(2), filter);
        TransferUtils.pullFluidNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (WrappedBlockFluidContainer)fluidContainer, (long)fluidCapacity, (int)0, (ConfigurationEntry)sideConfig.get(2), filter);
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        stack = ItemStackUtils.deriveCount(stack, 1);
        if (ArrayUtils.contains((int[])FLUID_SOURCE_SLOTS, (int)slot)) {
            ItemFluidContainer fluidContainer = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
            if (fluidContainer != null) {
                return fluidContainer.getFluids().stream().anyMatch(FuelLoaderBlockEntity::isFuel);
            }
            return false;
        }
        if (ArrayUtils.contains((int[])FLUID_SINK_SLOTS, (int)slot)) {
            return dir == null;
        }
        return super.m_7155_(slot, stack, dir);
    }

    public boolean m_7157_(int slot, ItemStack stack, @Nullable Direction dir) {
        if (ArrayUtils.contains((int[])FLUID_SOURCE_SLOTS, (int)slot)) {
            ItemFluidContainer fluidContainer = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
            if (fluidContainer != null) {
                return !fluidContainer.getFluids().stream().anyMatch(FuelLoaderBlockEntity::isFuel);
            }
        } else if (ArrayUtils.contains((int[])FLUID_SINK_SLOTS, (int)slot)) {
            return dir == null;
        }
        return super.m_7157_(slot, stack, dir);
    }

    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        super.serverTick(level, time, state, pos);
        if (this.canFunction()) {
            this.processTank();
            this.exchangeFuelItemAround();
        }
    }

    public void processTank() {
        FluidContainer tank = FluidContainer.of((BlockEntity)this, null);
        for (int slot : FLUID_SOURCE_SLOTS) {
            ItemFluidContainer source = FluidContainer.of((ItemStackHolder)ContainerHelper.getItem((Container)this, slot));
            if (source == null) continue;
            FluidUtils2.moveFluidAny((FluidContainer)source, tank, FuelLoaderBlockEntity::isFuel, false);
        }
        for (int slot : FLUID_SINK_SLOTS) {
            ItemFluidContainer sink = FluidContainer.of((ItemStackHolder)ContainerHelper.getItem((Container)this, slot));
            if (sink == null) continue;
            FluidUtils2.moveFluidAny(tank, (FluidContainer)sink, null, false);
        }
    }

    public void exchangeFuelItemAround() {
        Level level = this.m_58904_();
        AABB workingArea = this.getWorkingArea();
        List vehicles = level.m_45976_(Vehicle.class, workingArea);
        for (Vehicle vehicle : vehicles) {
            this.giveFuel(vehicle);
        }
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.sync();
            this.m_6596_();
        }
    }

    @Override
    public int getWorkingRange() {
        return MachinesConfig.FUEL_LOADER_WORKING_RANGE;
    }

    @Override
    public AABB getWorkingArea(double range) {
        return this.getWorkingArea(this.m_58899_(), range);
    }

    public FluidHolder giveFuel(Vehicle vehicle) {
        return this.giveFuel(vehicle, FluidConstants.fromMillibuckets((long)MachinesConfig.FUEL_LOADER_FLUID_TRANSFER));
    }

    private FluidHolder giveFuel(Vehicle vehicle, long transfer) {
        VehicleFuelInformation fuelInfo = VehicleHelper.getFuelInformation(vehicle);
        if (fuelInfo != null) {
            FluidContainer from = FluidContainer.of((BlockEntity)this, null);
            FluidHolder moved = FluidUtils2.moveFluidAny(from, fuelInfo.fuelTank(), fluid -> fluid.is(fuelInfo.fuelTag()), transfer, false);
            return moved;
        }
        return FluidHolder.empty();
    }

    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int[] m_7071_(Direction pSide) {
        return FLUID_SLOTS;
    }
}

