/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.event.bus;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;

public abstract class ZetaEventBus<E> {
    protected final Class<? extends Annotation> subscriberAnnotation;
    protected final Class<E> eventRoot;
    @Nullable
    protected final Logger logSpam;
    protected final Zeta ofZeta;

    public ZetaEventBus(Class<? extends Annotation> subscriberAnnotation, Class<E> eventRoot, @Nullable Logger logSpam, Zeta ofZeta) {
        Preconditions.checkArgument((boolean)eventRoot.isInterface(), (Object)"Event roots should be an interface");
        this.subscriberAnnotation = subscriberAnnotation;
        this.eventRoot = eventRoot;
        this.logSpam = logSpam;
        this.ofZeta = ofZeta;
    }

    public ZetaEventBus<E> subscribe(@NotNull Object target) {
        Class owningClazz;
        Object receiver;
        Preconditions.checkNotNull((Object)target, (Object)"null passed to subscribe");
        if (target instanceof Class) {
            Class clazz = (Class)target;
            receiver = null;
            owningClazz = clazz;
        } else {
            receiver = target;
            owningClazz = target.getClass();
        }
        this.streamAnnotatedMethods(owningClazz, receiver == null).forEach(m -> this.subscribeMethod((Method)m, receiver, owningClazz));
        return this;
    }

    public ZetaEventBus<E> unsubscribe(@NotNull Object target) {
        Class owningClazz;
        Object receiver;
        Preconditions.checkNotNull((Object)target, (Object)"null passed to unsubscribe");
        if (target instanceof Class) {
            Class clazz = (Class)target;
            receiver = null;
            owningClazz = clazz;
        } else {
            receiver = target;
            owningClazz = target.getClass();
        }
        this.streamAnnotatedMethods(owningClazz, receiver == null).forEach(m -> this.unsubscribeMethod((Method)m, receiver, owningClazz));
        return this;
    }

    protected abstract void unsubscribeMethod(Method var1, Object var2, Class<?> var3);

    protected abstract void subscribeMethod(Method var1, Object var2, Class<?> var3);

    public abstract <T extends E> T fire(@NotNull T var1);

    public abstract <T extends E> T fire(@NotNull T var1, Class<? super T> var2);

    private Stream<Method> streamAnnotatedMethods(Class<?> owningClazz, boolean wantStatic) {
        Stream<Method> methods;
        if (this.ofZeta.isProduction) {
            methods = Arrays.stream(owningClazz.getMethods());
        } else {
            ArrayList list = new ArrayList();
            while (owningClazz != null) {
                Collections.addAll(list, owningClazz.getDeclaredMethods());
                owningClazz = owningClazz.getSuperclass();
            }
            methods = list.stream();
        }
        return methods.filter(m -> m.isAnnotationPresent(this.subscriberAnnotation) && (m.getModifiers() & 8) != 0 == wantStatic);
    }

    protected RuntimeException arityERR(Method method) {
        return ZetaEventBus.methodProblem("Method annotated with @" + this.subscriberAnnotation.getSimpleName() + " should take 1 parameter.", method, null);
    }

    protected RuntimeException typeERR(Method method) {
        return ZetaEventBus.methodProblem("Method annotated with @" + this.subscriberAnnotation.getSimpleName() + " should take an implementor of " + this.eventRoot.getSimpleName() + ".", method, null);
    }

    protected RuntimeException unreflectERR(Method method, Throwable cause) {
        return ZetaEventBus.methodProblem("Exception unreflecting a @" + this.subscriberAnnotation.getSimpleName() + " method, is it public?", method, cause);
    }

    protected static RuntimeException methodProblem(String problem, Method method, @Nullable Throwable cause) {
        return new RuntimeException("%s%nMethod class: %s%nMethod name: %s".formatted(problem, method.getDeclaringClass().getName(), method.getName()), cause);
    }

    @Deprecated(forRemoval=true)
    public <T extends E> T fireExternal(@NotNull T event, Class<? super T> firedAs) {
        return event;
    }
}

