/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class ZetaTrapdoorBlock
extends TrapDoorBlock
implements IZetaBlock {
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;

    public ZetaTrapdoorBlock(BlockSetType setType, String regname, ZetaModule module, BlockBehaviour.Properties properties) {
        super(properties, setType);
        this.module = module;
        if (module == null) {
            throw new IllegalArgumentException("Must provide a module for ZetaTrapdoorBlock");
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        module.zeta().registry.registerBlock((Block)this, regname, true);
        CreativeTabManager.addToCreativeTab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_, (ItemLike)this);
        CreativeTabManager.addToCreativeTab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_, (ItemLike)this);
    }

    @Override
    public boolean isLadderZeta(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            BlockPos downPos = pos.m_7495_();
            BlockState down = level.m_8055_(downPos);
            return this.module.zeta().blockExtensions.get(down).makesOpenTrapdoorAboveClimbableZeta(down, level, downPos, state);
        }
        return false;
    }

    @Override
    public ZetaTrapdoorBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }
}

