/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.api;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.annotation.ConditionalMixin;

@ApiStatus.Internal
public class ConditionalMixinManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"ZetaConditionalMixinManager");

    public static boolean shouldApply(Zeta zeta, String targetClassName, String mixinClassName) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)targetClassName).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            boolean shouldApply = true;
            for (AnnotationNode node : annotationNodes) {
                if (!node.desc.equals(Type.getDescriptor(ConditionalMixin.class))) continue;
                List mods = (List)Annotations.getValue((AnnotationNode)node, (String)"value");
                boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                boolean anyModsLoaded = ConditionalMixinManager.areModsLoaded(zeta, mods);
                shouldApply = anyModsLoaded == applyIfPresent;
                LOGGER.info("{}: {} is{}being applied because the mod(s) {} are{}loaded", (Object)zeta.getModDisplayName(zeta.modid), (Object)targetClassName, (Object)(shouldApply ? " " : " not "), (Object)mods, (Object)(anyModsLoaded ? " " : " not "));
            }
            return shouldApply;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean areModsLoaded(Zeta zeta, List<String> modids) {
        for (String mod : modids) {
            if (!zeta.isModLoaded(mod)) continue;
            return true;
        }
        return false;
    }
}

