/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.traderefresh.init;

import dev.xkmc.l2serial.network.BasePacketHandler;
import dev.xkmc.l2serial.serialization.custom_handler.Handlers;
import dev.xkmc.traderefresh.common.EnchantmentLimiter;
import dev.xkmc.traderefresh.common.RestockEventHandler;
import dev.xkmc.traderefresh.init.TRConfig;
import dev.xkmc.traderefresh.init.TradeRefreshClient;
import dev.xkmc.traderefresh.network.RefreshToServer;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="traderefresh")
public class TradeRefresh {
    public static final String MODID = "traderefresh";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final BasePacketHandler HANDLER = new BasePacketHandler(new ResourceLocation("traderefresh", "main"), 1, new Function[]{e -> e.create(RefreshToServer.class, NetworkDirection.PLAY_TO_SERVER)});

    private static void registerForgeEvents() {
        MinecraftForge.EVENT_BUS.register(RestockEventHandler.class);
    }

    private static void registerModBusEvents(IEventBus bus) {
        bus.addListener(TradeRefresh::commonSetup);
    }

    public TradeRefresh() {
        Handlers.register();
        TRConfig.init();
        FMLJavaModLoadingContext ctx = FMLJavaModLoadingContext.get();
        IEventBus bus = ctx.getModEventBus();
        TradeRefresh.registerModBusEvents(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TradeRefreshClient.onCtorClient(bus, MinecraftForge.EVENT_BUS));
        TradeRefresh.registerForgeEvents();
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HANDLER.registerPackets();
            for (Map.Entry ent : ForgeRegistries.ENCHANTMENTS.getEntries()) {
                Enchantment e = (Enchantment)ent.getValue();
                if (e.m_6592_() && !EnchantmentLimiter.enchantable(e)) {
                    LOGGER.error("Enchantment " + ((ResourceKey)ent.getKey()).m_135782_() + " does not conform with table restrictions");
                }
                if (!e.m_6594_() || EnchantmentLimiter.tradable(e)) continue;
                LOGGER.error("Enchantment " + ((ResourceKey)ent.getKey()).m_135782_() + " does not conform with trade restrictions");
            }
        });
    }
}

