/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.traderefresh.common;

import dev.xkmc.traderefresh.init.TRConfig;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class RestockEventHandler {
    @SubscribeEvent
    public static void onMobInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (!((Boolean)TRConfig.COMMON.allowEmeraldBlockForceRestock.get()).booleanValue()) {
            return;
        }
        if (event.getItemStack().m_150930_(Items.f_42110_) && (entity = event.getTarget()) instanceof Villager) {
            Villager villager = (Villager)entity;
            if (event.getLevel().m_5776_()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
            if (villager.m_7809_() > 0 && villager.m_35520_()) {
                villager.m_35531_();
                villager.m_35510_();
                event.getItemStack().m_41774_(1);
                event.setCancellationResult(InteractionResult.CONSUME);
                event.setCanceled(true);
                event.getLevel().m_7605_((Entity)villager, (byte)14);
                villager.m_5496_(SoundEvents.f_12509_, 1.0f, villager.m_6100_());
            } else {
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
                villager.m_35319_(40);
                villager.m_5496_(SoundEvents.f_12507_, 1.0f, villager.m_6100_());
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (ModList.get().isLoaded("apotheosis")) {
            return;
        }
        if (!((Boolean)TRConfig.CLIENT.showEnchProperties.get()).booleanValue()) {
            return;
        }
        if (!event.getItemStack().m_150930_(Items.f_42690_)) {
            return;
        }
        Map map = EnchantmentHelper.m_44831_((ItemStack)event.getItemStack());
        if (map.size() != 1) {
            return;
        }
        Optional opt = map.entrySet().stream().findFirst();
        if (opt.isEmpty()) {
            return;
        }
        Enchantment e = (Enchantment)((Map.Entry)opt.get()).getKey();
        boolean enchatable = e.m_6592_() && !e.m_6591_();
        boolean tradable = e.m_6594_();
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((Object)e);
        assert (id != null);
        event.getToolTip().add(RestockEventHandler.getComp("enchantable", enchatable));
        event.getToolTip().add(RestockEventHandler.getComp("tradable", tradable));
        event.getToolTip().add(Component.m_237113_((String)id.toString()).m_130940_(ChatFormatting.DARK_GRAY));
    }

    private static MutableComponent getComp(String str, boolean enabled) {
        return Component.m_237115_((String)("traderefresh." + str + "." + enabled)).m_130940_(enabled ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED);
    }
}

