/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.config.integrated;

import com.christofmeg.justenoughbreeding.jei.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EarthMobsIntegration {
    static final String MOD = "earthmobsmod";
    static final List<String> animalNames = new ArrayList<String>();
    static final List<String> tamableOnly = new ArrayList<String>();
    static final Map<String, String> ingredients = new HashMap<String, String>();
    static final Map<String, Boolean> needsToBeTamed = new HashMap<String, Boolean>();
    static final Map<String, Integer> breedingCooldown = new HashMap<String, Integer>();
    static final Map<String, String> tamingIngredients = new HashMap<String, String>();
    static final Map<String, Integer> tamingChance = new HashMap<String, Integer>();
    static final Map<String, List<TemperRecipe>> temperDataMap = new HashMap<String, List<TemperRecipe>>();

    public static void init() {
        CommonUtils.addAnimal("albino_cow", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("cluck_shroom", "minecraft:wheat_seeds, minecraft:pumpkin_seeds, minecraft:melon_seeds, minecraft:beetroot_seeds, minecraft:torchflower_seeds, minecraft:pitcher_pod", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("cream_cow", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("duck", "minecraft:wheat_seeds, minecraft:pumpkin_seeds, minecraft:melon_seeds, minecraft:beetroot_seeds, minecraft:torchflower_seeds, minecraft:pitcher_pod", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("fancy_chicken", "minecraft:wheat_seeds, minecraft:pumpkin_seeds, minecraft:melon_seeds, minecraft:beetroot_seeds, minecraft:torchflower_seeds, minecraft:pitcher_pod", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("horned_sheep", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("hyper_rabbit", "minecraft:dandelion, minecraft:carrot, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("jolly_llama", "minecraft:wheat, minecraft:hay_block", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addAnimal("jumbo_rabbit", "minecraft:dandelion, minecraft:carrot, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("magma_cow", "minecraft:magma_cream", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("moobloom", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("moolip", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("teacup_pig", "minecraft:carrot, minecraft:potato, minecraft:beetroot", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("umbra_cow", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("wooly_cow", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("zombified_pig", "minecraft:carrot, minecraft:potato, minecraft:beetroot", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("zombified_rabbit", "minecraft:dandelion, minecraft:carrot, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalNames(animalNames, ingredients, MOD, breedingCooldown, needsToBeTamed);
        CommonUtils.addTamableOnly("baby_ghast", "minecraft:crimson_nylium, minecraft:crimson_fungus", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("skelton_wolf", "minecraft:bone, minecraft:rotten_flesh", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("wither_skelton_wolf", "minecraft:bone, minecraft:rotten_flesh", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableAnimalNames(tamableOnly, tamingIngredients, tamingChance, MOD);
        CommonUtils.addTemperAnimal("jolly_llama", new String[]{"minecraft:wheat", "minecraft:hay_block"}, new int[]{3, 6}, temperDataMap);
        CommonUtils.addAnimalTempers(temperDataMap, MOD);
    }
}

