/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.item;

import alabaster.crabbersdelight.common.registry.ModItems;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CrabClawItem
extends Item {
    public static final int MAX_DAMAGE = 128;
    public static final AttributeModifier rangeAttributeModifier = new AttributeModifier(UUID.fromString("7f7dbdb2-0d0d-458a-aa40-ac7633691f66"), "Range Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final Supplier<Multimap<Attribute, AttributeModifier>> rangeModifier = Suppliers.memoize(() -> ImmutableMultimap.of((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)rangeAttributeModifier));
    public static final String CLAW_MARKER = "clawMarker";

    public CrabClawItem(Item.Properties properties) {
        super(properties.m_41503_(128));
    }

    @SubscribeEvent
    public static void extendRange(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag persistentData = player.getPersistentData();
        boolean clawMainHand = player.m_21205_().m_150930_((Item)ModItems.CRAB_CLAW.get());
        boolean clawOffHand = player.m_21206_().m_150930_((Item)ModItems.CRAB_CLAW.get());
        boolean clawHeld = clawMainHand ^ clawOffHand;
        boolean hadClaw = persistentData.m_128441_(CLAW_MARKER);
        if (clawHeld != hadClaw) {
            if (!clawHeld) {
                player.m_21204_().m_22161_(rangeModifier.get());
                persistentData.m_128473_(CLAW_MARKER);
            } else {
                player.m_21204_().m_22178_(rangeModifier.get());
                persistentData.m_128379_(CLAW_MARKER, true);
            }
        }
    }

    @SubscribeEvent
    public static void adjustReachOnJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_(CLAW_MARKER)) {
            player.m_21204_().m_22178_(rangeModifier.get());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeOnBreak(BlockEvent.BreakEvent event) {
        CrabClawItem.damageClaw(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeOnPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            CrabClawItem.damageClaw((Player)entity);
        }
    }

    public boolean m_7579_(ItemStack claw, LivingEntity target, LivingEntity attacker) {
        claw.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    private static void damageClaw(Player player) {
        InteractionHand h;
        ItemStack claw;
        InteractionHand hand;
        if (player == null) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (player.m_21206_().m_150930_((Item)ModItems.CRAB_CLAW.get())) {
            hand = InteractionHand.OFF_HAND;
            claw = player.m_21206_();
            h = hand;
            claw.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(h));
        }
        if (player.m_21205_().m_150930_((Item)ModItems.CRAB_CLAW.get())) {
            hand = InteractionHand.MAIN_HAND;
            claw = player.m_21205_();
            h = hand;
            claw.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(h));
        }
    }
}

