/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.utils;

import com.tarinoita.solsweetpotato.SOLSweetPotato;
import com.tarinoita.solsweetpotato.tracking.benefits.AttributeBenefit;
import com.tarinoita.solsweetpotato.tracking.benefits.Benefit;
import com.tarinoita.solsweetpotato.tracking.benefits.EffectBenefit;
import java.util.ArrayList;
import java.util.List;

public class BenefitsParser {
    public static List<List<Benefit>> parse(List<String> unparsed) {
        ArrayList<List<Benefit>> allBenefits = new ArrayList<List<Benefit>>();
        int thresh = 0;
        for (String s : unparsed) {
            String[] thresholdBenefitsString = s.split(";", 0);
            ArrayList<Benefit> thresholdBenefits = new ArrayList<Benefit>();
            for (String benefitString : thresholdBenefitsString) {
                String benefitType;
                boolean is_detriment = false;
                switch (benefitString.charAt(0)) {
                    case '-': {
                        is_detriment = true;
                    }
                    case '+': {
                        benefitString = benefitString.substring(1);
                    }
                }
                String[] benefitArgs = benefitString.split(",", 0);
                int len = benefitArgs.length;
                if (len < 2) {
                    SOLSweetPotato.LOGGER.warn("Invalid benefit specification: " + benefitString);
                    continue;
                }
                if (benefitArgs[0].equals("attribute")) {
                    if (len < 3) {
                        SOLSweetPotato.LOGGER.warn("Need to specify a value when defining an attribute benefit: " + benefitString);
                    }
                    benefitType = "attribute";
                } else if (benefitArgs[0].equals("effect")) {
                    benefitType = "effect";
                } else {
                    SOLSweetPotato.LOGGER.warn("Invalid benefit type: " + benefitArgs[0] + " in string " + benefitString);
                    continue;
                }
                String benefitName = benefitArgs[1];
                double benefitValue = 0.0;
                if (len > 2) {
                    benefitValue = Double.parseDouble(benefitArgs[2]);
                }
                if (benefitType.equals("attribute")) {
                    thresholdBenefits.add(new AttributeBenefit(benefitName, benefitValue, thresh, is_detriment));
                    continue;
                }
                if (!benefitType.equals("effect")) continue;
                thresholdBenefits.add(new EffectBenefit(benefitName, benefitValue, thresh, is_detriment));
            }
            allBenefits.add(thresholdBenefits);
            ++thresh;
        }
        return allBenefits;
    }
}

