/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.silentsdelight.datagen;

import com.scouter.silentsdelight.datagen.BlockTagGenerator;
import com.scouter.silentsdelight.datagen.ItemModelGenerator;
import com.scouter.silentsdelight.datagen.ItemTagGenerator;
import com.scouter.silentsdelight.datagen.LanguageGenerator;
import com.scouter.silentsdelight.datagen.RecipeGenerator;
import com.scouter.silentsdelight.datagen.SDAdvancements;
import com.scouter.silentsdelight.datagen.SDBlockStateGenerator;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.InclusiveRange;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="silentsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LanguageGenerator(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new SDBlockStateGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new SDAdvancements(packOutput, lookupProvider, existingFileHelper));
        BlockTagGenerator blockTagGenerator = (BlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new BlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        Map packVersions = Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0)));
        InclusiveRange supportedFormatsRange = new InclusiveRange((Comparable)packVersions.values().stream().min(Integer::compareTo).orElse(1), (Comparable)packVersions.values().stream().max(Integer::compareTo).orElse(1));
    }
}

