/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.silentsdelight.blocks;

import com.scouter.silentsdelight.advancements.SDCriteriaTriggers;
import com.scouter.silentsdelight.blocks.PieBaseBlockEntity;
import com.scouter.silentsdelight.blocks.SDBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class SculkCatalystPieEntity
extends BlockEntity
implements GameEventListener.Holder<CatalystListener> {
    private final CatalystListener catalystListener;

    public SculkCatalystPieEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SDBlockEntities.CATALYST_PIE.get(), pPos, pBlockState);
        this.catalystListener = new CatalystListener(pBlockState, (PositionSource)new BlockPositionSource(pPos));
    }

    public CatalystListener getListener() {
        return this.catalystListener;
    }

    public static class CatalystListener
    implements GameEventListener {
        private final BlockState blockState;
        private final PositionSource positionSource;

        public CatalystListener(BlockState p_283224_, PositionSource p_283095_) {
            this.blockState = p_283224_;
            this.positionSource = p_283095_;
        }

        public PositionSource m_142460_() {
            return this.positionSource;
        }

        public int m_142078_() {
            return 8;
        }

        public GameEventListener.DeliveryMode m_247514_() {
            return GameEventListener.DeliveryMode.BY_DISTANCE;
        }

        public boolean m_214068_(ServerLevel p_283470_, GameEvent p_282184_, GameEvent.Context p_283014_, Vec3 p_282350_) {
            Entity $$5;
            if (p_282184_ == GameEvent.f_223707_ && ($$5 = p_283014_.f_223711_()) instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)$$5;
                if (!livingentity.m_217046_()) {
                    int i = livingentity.m_213860_();
                    if (livingentity.m_6149_() && i > 0) {
                        this.tryAwardItSpreadsAdvancement((Level)p_283470_, livingentity);
                    }
                    livingentity.m_217045_();
                    this.positionSource.m_142502_((Level)p_283470_).ifPresent(p_289513_ -> this.bloom(p_283470_, BlockPos.m_274446_((Position)p_289513_), this.blockState, p_283470_.m_213780_()));
                }
                return true;
            }
            return false;
        }

        private void bloom(ServerLevel serverLevel, BlockPos pos, BlockState state, RandomSource randomSource) {
            this.safelyUpdate(serverLevel, pos, serverLevel.m_8055_(pos));
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.15, (double)pos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            serverLevel.m_5594_((Player)null, pos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 0.6f + randomSource.m_188501_() * 0.4f);
        }

        private void safelyUpdate(ServerLevel serverLevel, BlockPos pos, BlockState state) {
            if (state.m_61138_((Property)PieBaseBlockEntity.BITES)) {
                int max = PieBaseBlockEntity.BITES.m_6908_().size();
                int curVal = (Integer)state.m_61143_((Property)PieBaseBlockEntity.BITES);
                if (curVal < max && curVal > 0) {
                    serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)PieBaseBlockEntity.BITES, (Comparable)Integer.valueOf(curVal - 1)), 3);
                }
            }
        }

        private void tryAwardItSpreadsAdvancement(Level p_281279_, LivingEntity p_281378_) {
            LivingEntity livingentity = p_281378_.m_21188_();
            if (livingentity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)livingentity;
                DamageSource damagesource = p_281378_.m_21225_() == null ? p_281279_.m_269111_().m_269075_((Player)serverplayer) : p_281378_.m_21225_();
                SDCriteriaTriggers.KILL_MOB_NEAR_SCULK_CATALYST_PIE.m_48104_(serverplayer, (Entity)p_281378_, damagesource);
            }
        }
    }
}

