/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class VillageStructures {
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        if (((Boolean)Configuration.GENERATE_VILLAGE_COMPOST_HEAPS.get()).booleanValue()) {
            Registry templatePools = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).get();
            Registry processorLists = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_257011_).get();
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, new ResourceLocation("minecraft:village/plains/houses"), "farmersdelight:village/houses/plains_compost_pile", 5);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, new ResourceLocation("minecraft:village/snowy/houses"), "farmersdelight:village/houses/snowy_compost_pile", 3);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, new ResourceLocation("minecraft:village/savanna/houses"), "farmersdelight:village/houses/savanna_compost_pile", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, new ResourceLocation("minecraft:village/desert/houses"), "farmersdelight:village/houses/desert_compost_pile", 3);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, new ResourceLocation("minecraft:village/taiga/houses"), "farmersdelight:village/houses/taiga_compost_pile", 4);
        }
        if (((Boolean)Configuration.GENERATE_VILLAGE_FARM_FD_CROPS.get()).booleanValue()) {
            Registry processorLists = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
            RuleProcessor temperateCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.CABBAGE_CROP.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.TOMATO_CROP.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.ONION_CROP.get()).m_49966_())));
            RuleProcessor coldCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.CABBAGE_CROP.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.ONION_CROP.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50250_, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.CABBAGE_CROP.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50250_, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.ONION_CROP.get()).m_49966_())));
            RuleProcessor aridCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.CABBAGE_CROP.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.3f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)ModBlocks.TOMATO_CROP.get()).m_49966_())));
            VillageStructures.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_plains"), (StructureProcessor)temperateCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_savanna"), (StructureProcessor)aridCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_snowy"), (StructureProcessor)coldCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_taiga"), (StructureProcessor)temperateCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(new ResourceLocation("minecraft:farm_desert"), (StructureProcessor)aridCropProcessor, (Registry<StructureProcessorList>)processorLists);
        }
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        ResourceLocation emptyProcessor = new ResourceLocation("minecraft", "empty");
        Holder.Reference processorHolder = processorListRegistry.m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)emptyProcessor));
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    private static void addNewRuleToProcessorList(ResourceLocation targetProcessorList, StructureProcessor processorToAdd, Registry<StructureProcessorList> processorListRegistry) {
        processorListRegistry.m_6612_(targetProcessorList).ifPresent(processorList -> {
            ArrayList<StructureProcessor> newSafeList = new ArrayList<StructureProcessor>(processorList.m_74425_());
            newSafeList.add(processorToAdd);
            processorList.f_74422_ = newSafeList;
        });
    }
}

