/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util.block;

import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.init.ModBlocks;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public final class BlockRayTrace {
    private static final Predicate<BlockState> IGNORES = input -> input != null && input.m_204336_(ModBlocks.BULLET_IGNORE_BLOCKS);

    public static BlockHitResult rayTraceBlocks(Level level, ClipContext context) {
        return BlockRayTrace.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = level.m_8055_(blockPos);
            List ids = (List)AmmoConfig.PASS_THROUGH_BLOCKS.get();
            ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
            if (blockId != null && ids.contains(blockId.toString())) {
                return null;
            }
            if (IGNORES.test(blockState)) {
                return null;
            }
            return BlockRayTrace.getBlockHitResult(level, rayTraceContext, blockPos, blockState);
        }, rayTraceContext -> {
            Vec3 vec3 = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
    }

    @Nullable
    private static BlockHitResult getBlockHitResult(Level level, ClipContext rayTraceContext, BlockPos blockPos, BlockState blockState) {
        FluidState fluidState = level.m_6425_(blockPos);
        Vec3 startVec = rayTraceContext.m_45702_();
        Vec3 endVec = rayTraceContext.m_45693_();
        VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)level, blockPos);
        BlockHitResult blockResult = level.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
        VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)level, blockPos);
        BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
        double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
        double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
        return blockDistance <= fluidDistance ? blockResult : fluidResult;
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> missFactory) {
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (!startVec.equals((Object)(endVec = context.m_45693_()))) {
            int blockZ;
            int blockY;
            double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
            double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
            double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
            double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
            double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
            double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
            int blockX = Mth.m_14107_((double)endX);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
            T t = hitFunction.apply(context, (BlockPos)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = Mth.m_14205_((double)deltaX);
            int signY = Mth.m_14205_((double)deltaY);
            int signZ = Mth.m_14205_((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return missFactory.apply(context);
    }
}

