/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.config.common.GunConfig;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource_legacy.CommonGunPackLoader;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SilenceModifier
implements IAttachmentModifier<Pair<Modifier, Boolean>, Pair<Integer, Boolean>> {
    public static final String ID = "silence";

    @Override
    public String getId() {
        return ID;
    }

    public SilenceJsonProperty readJson(String json) {
        Data data = (Data)CommonGunPackLoader.GSON.fromJson(json, Data.class);
        Silence silence = data.getSilence();
        if (silence == null) {
            return new SilenceJsonProperty((Pair<Modifier, Boolean>)Pair.of((Object)new Modifier(), (Object)false));
        }
        Modifier distance = silence.getDistance();
        if (distance == null) {
            distance = new Modifier();
            distance.setAddend(silence.getDistanceAddend());
        }
        return new SilenceJsonProperty((Pair<Modifier, Boolean>)Pair.of((Object)distance, (Object)silence.isUseSilenceSound()));
    }

    @Override
    public CacheValue<Pair<Integer, Boolean>> initCache(ItemStack gunItem, GunData gunData) {
        int defaultDistance = (Integer)GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE.get();
        return new CacheValue<Pair<Integer, Boolean>>(Pair.of((Object)defaultDistance, (Object)false));
    }

    @Override
    public void eval(List<Pair<Modifier, Boolean>> modifiedValues, CacheValue<Pair<Integer, Boolean>> cache) {
        ArrayList distanceModifiers = Lists.newArrayList();
        ArrayList useSilenceSoundModifiers = Lists.newArrayList();
        modifiedValues.forEach(v -> {
            distanceModifiers.add((Modifier)v.left());
            useSilenceSoundModifiers.add((Boolean)v.right());
        });
        Pair<Integer, Boolean> cacheValue = cache.getValue();
        double evalDistance = AttachmentPropertyManager.eval(distanceModifiers, (double)((Integer)cacheValue.left()).intValue());
        boolean useSilenceSound = AttachmentPropertyManager.eval(useSilenceSoundModifiers, (Boolean)cacheValue.right());
        cache.setValue((Pair<Integer, Boolean>)Pair.of((Object)((int)Math.round(evalDistance)), (Object)useSilenceSound));
    }

    private static class Data {
        @Nullable
        @SerializedName(value="silence")
        private Silence silence = null;

        private Data() {
        }

        @Nullable
        public Silence getSilence() {
            return this.silence;
        }
    }

    private static class Silence {
        @Deprecated
        @SerializedName(value="distance_addend")
        private int distanceAddend = 0;
        @Nullable
        @SerializedName(value="distance")
        private Modifier distance = null;
        @SerializedName(value="use_silence_sound")
        private boolean useSilenceSound = false;

        private Silence() {
        }

        @Deprecated
        public int getDistanceAddend() {
            return this.distanceAddend;
        }

        @Nullable
        public Modifier getDistance() {
            return this.distance;
        }

        public boolean isUseSilenceSound() {
            return this.useSilenceSound;
        }
    }

    public static class SilenceJsonProperty
    extends JsonProperty<Pair<Modifier, Boolean>> {
        public SilenceJsonProperty(Pair<Modifier, Boolean> value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Pair value = (Pair)this.getValue();
            if (value != null) {
                int defaultDistance = (Integer)GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE.get();
                double eval = AttachmentPropertyManager.eval((Modifier)value.left(), (double)defaultDistance);
                int distance = (int)Math.round(eval);
                if (distance > defaultDistance) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.sound_distance.increase").m_130940_(ChatFormatting.RED));
                } else if (distance < defaultDistance) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.sound_distance.increase").m_130940_(ChatFormatting.GREEN));
                }
                if (((Boolean)value.right()).booleanValue()) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.silence").m_130940_(ChatFormatting.GREEN));
                }
            }
        }
    }
}

