/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier;

import com.google.common.collect.Maps;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.AttachmentPropertyEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.AdsModifier;
import com.tacz.guns.resource.modifier.custom.AimInaccuracyModifier;
import com.tacz.guns.resource.modifier.custom.AmmoSpeedModifier;
import com.tacz.guns.resource.modifier.custom.ArmorIgnoreModifier;
import com.tacz.guns.resource.modifier.custom.DamageModifier;
import com.tacz.guns.resource.modifier.custom.EffectiveRangeModifier;
import com.tacz.guns.resource.modifier.custom.ExplosionModifier;
import com.tacz.guns.resource.modifier.custom.ExtraMovementModifier;
import com.tacz.guns.resource.modifier.custom.HeadShotModifier;
import com.tacz.guns.resource.modifier.custom.IgniteModifier;
import com.tacz.guns.resource.modifier.custom.InaccuracyModifier;
import com.tacz.guns.resource.modifier.custom.KnockbackModifier;
import com.tacz.guns.resource.modifier.custom.PierceModifier;
import com.tacz.guns.resource.modifier.custom.RecoilModifier;
import com.tacz.guns.resource.modifier.custom.RpmModifier;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import com.tacz.guns.resource.modifier.custom.WeightModifier;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.StringUtils;
import org.luaj.vm2.script.LuaScriptEngineFactory;

public class AttachmentPropertyManager {
    private static final ScriptEngine LUAJ_ENGINE = new LuaScriptEngineFactory().getScriptEngine();
    private static final Map<String, IAttachmentModifier<?, ?>> MODIFIERS = Maps.newLinkedHashMap();

    public static void registerModifier() {
        MODIFIERS.put("ads", new AdsModifier());
        MODIFIERS.put("aim_inaccuracy", new AimInaccuracyModifier());
        MODIFIERS.put("ammo_speed", new AmmoSpeedModifier());
        MODIFIERS.put("armor_ignore", new ArmorIgnoreModifier());
        MODIFIERS.put("damage", new DamageModifier());
        MODIFIERS.put("effective_range", new EffectiveRangeModifier());
        MODIFIERS.put("explosion", new ExplosionModifier());
        MODIFIERS.put("head_shot", new HeadShotModifier());
        MODIFIERS.put("ignite", new IgniteModifier());
        MODIFIERS.put("inaccuracy", new InaccuracyModifier());
        MODIFIERS.put("knockback", new KnockbackModifier());
        MODIFIERS.put("pierce", new PierceModifier());
        MODIFIERS.put("recoil", new RecoilModifier());
        MODIFIERS.put("rpm", new RpmModifier());
        MODIFIERS.put("silence", new SilenceModifier());
        MODIFIERS.put("weight_modifier", new WeightModifier());
        MODIFIERS.put("movement_speed", new ExtraMovementModifier());
    }

    public static Map<String, IAttachmentModifier<?, ?>> getModifiers() {
        return MODIFIERS;
    }

    public static void postChangeEvent(LivingEntity shooter, ItemStack gunItem) {
        Item item = gunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            AttachmentCacheProperty cacheProperty = new AttachmentCacheProperty();
            MinecraftForge.EVENT_BUS.post((Event)new AttachmentPropertyEvent(gunItem, cacheProperty));
            IGunOperator.fromLivingEntity(shooter).updateCacheProperty(cacheProperty);
        });
    }

    public static double eval(Modifier modifier, double defaultValue) {
        return AttachmentPropertyManager.eval(Collections.singletonList(modifier), defaultValue);
    }

    public static double eval(List<Modifier> modifiers, double defaultValue) {
        double addend = defaultValue;
        double percent = 1.0;
        double multiplier = 1.0;
        for (Modifier modifier : modifiers) {
            addend += modifier.getAddend();
            percent += modifier.getPercent();
            multiplier *= Math.max(modifier.getMultiplier(), 0.0);
        }
        percent = Math.max(percent, 0.0);
        double value = addend * percent * multiplier;
        for (Modifier modifier : modifiers) {
            String function = modifier.getFunction();
            if (StringUtils.isEmpty((CharSequence)function)) continue;
            value = AttachmentPropertyManager.functionEval(value, defaultValue, function);
        }
        return value;
    }

    public static boolean eval(List<Boolean> modified, boolean defaultValue) {
        if (defaultValue) {
            return modified.stream().allMatch(s -> s);
        }
        return modified.stream().anyMatch(s -> s);
    }

    public static double functionEval(double value, double defaultValue, String script) {
        script = script.toLowerCase(Locale.ENGLISH);
        LUAJ_ENGINE.put("x", value);
        LUAJ_ENGINE.put("r", defaultValue);
        try {
            LUAJ_ENGINE.eval(script);
        }
        catch (ScriptException e) {
            GunMod.LOGGER.catching((Throwable)e);
        }
        Object object = LUAJ_ENGINE.get("y");
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        return value;
    }
}

