/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.util.ResourceScanner;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class JsonDataManager<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    protected final Map<ResourceLocation, T> dataMap = Maps.newHashMap();
    private final Gson gson;
    private final Class<T> dataClass;
    private final Marker marker;
    private final FileToIdConverter fileToIdConverter;

    public JsonDataManager(Class<T> dataClass, Gson pGson, String directory, String marker) {
        this(dataClass, pGson, FileToIdConverter.m_246568_((String)directory), marker);
    }

    public JsonDataManager(Class<T> dataClass, Gson pGson, FileToIdConverter fileToIdConverter, String marker) {
        this.gson = pGson;
        this.dataClass = dataClass;
        this.marker = MarkerManager.getMarker((String)marker);
        this.fileToIdConverter = fileToIdConverter;
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return ResourceScanner.scanDirectory(pResourceManager, this.fileToIdConverter, this.gson);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.dataMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                T data = this.parseJson(element);
                if (data == null) continue;
                this.dataMap.put(id, data);
            }
            catch (JsonParseException e) {
                GunMod.LOGGER.error(this.marker, "Failed to load data file {}", (Object)id, (Object)e);
            }
        }
    }

    protected T parseJson(JsonElement element) {
        return (T)this.gson.fromJson(element, this.getDataClass());
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public Gson getGson() {
        return this.gson;
    }

    public T getData(ResourceLocation id) {
        return this.dataMap.get(id);
    }

    public Map<ResourceLocation, T> getAllData() {
        return this.dataMap;
    }
}

