/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.filter;

import com.tacz.guns.resource.filter.IFilter;
import java.util.HashSet;
import java.util.Set;

public class LiteralFilter<T>
implements IFilter<T> {
    private final Set<T> set;

    public LiteralFilter(Set<T> set) {
        this.set = set;
    }

    @Override
    public boolean test(T input) {
        return this.set.contains(input);
    }

    public Set<T> getSet() {
        return this.set;
    }

    public static class Builder<T> {
        private final Set<T> entries = new HashSet<T>();

        public Builder<T> add(T item) {
            this.entries.add(item);
            return this;
        }

        public LiteralFilter<T> build() {
            return new LiteralFilter<T>(this.entries);
        }

        public static <T> Builder<T> create() {
            return new Builder<T>();
        }
    }
}

