/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LivingEntityBolt {
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;
    private final LivingEntity shooter;

    public LivingEntityBolt(ShooterDataHolder data, LivingEntity shooter, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
        this.shooter = shooter;
    }

    public void bolt() {
        if (this.data.currentGunItem == null) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem iGun = (AbstractGunItem)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.isBolting) {
                return;
            }
            Bolt boltType = gunIndex.getGunData().getBolt();
            if (boltType != Bolt.MANUAL_ACTION) {
                return;
            }
            if (iGun.hasBulletInBarrel(currentGunItem)) {
                return;
            }
            if (iGun.getCurrentAmmoCount(currentGunItem) == 0) {
                return;
            }
            this.data.boltTimestamp = System.currentTimeMillis();
            this.data.isBolting = iGun.startBolt(this.data, currentGunItem, this.shooter);
        });
    }

    public void tickBolt() {
        if (!this.data.isBolting) {
            return;
        }
        if (this.data.currentGunItem == null) {
            this.data.isBolting = false;
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof AbstractGunItem)) {
            this.data.isBolting = false;
            return;
        }
        AbstractGunItem iGun = (AbstractGunItem)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        this.data.isBolting = gunIndex.map(index -> iGun.tickBolt(this.data, currentGunItem, this.shooter)).orElse(false);
    }
}

