/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.entity.TargetMinecart;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TargetMinecartRenderer
extends MinecartRenderer<TargetMinecart> {
    private static final String HEAD_NAME = "head";
    private static final String HEAD_2_NAME = "head2";

    public TargetMinecartRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, ModelLayers.f_171253_);
        this.f_114477_ = 0.25f;
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.TARGET_MINECART_MODEL_LOCATION);
    }

    public ResourceLocation getTextureLocation(TargetMinecart minecart) {
        return InternalAssetLoader.ENTITY_EMPTY_TEXTURE;
    }

    protected void renderMinecartContents(TargetMinecart targetMinecart, float pPartialTicks, BlockState pState, PoseStack stack, MultiBufferSource buffer, int pPackedLight) {
        TargetMinecartRenderer.getModel().ifPresent(model -> {
            BedrockPart headModel = model.getNode(HEAD_NAME);
            BedrockPart head2Model = model.getNode(HEAD_2_NAME);
            headModel.visible = false;
            head2Model.visible = false;
            stack.m_85836_();
            stack.m_85837_(0.5, 1.875, 0.5);
            stack.m_85841_(1.5f, 1.5f, 1.5f);
            stack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            stack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
            RenderType renderType = RenderType.m_110473_((ResourceLocation)InternalAssetLoader.TARGET_MINECART_TEXTURE_LOCATION);
            model.render(stack, ItemDisplayContext.NONE, renderType, pPackedLight, OverlayTexture.f_118083_);
            if (targetMinecart.getGameProfile() != null) {
                stack.m_85837_(0.0, 1.0, -0.28125);
                Minecraft minecraft = Minecraft.m_91087_();
                GameProfile gameProfile = targetMinecart.getGameProfile();
                Map map = minecraft.m_91109_().m_118815_(gameProfile);
                ResourceLocation skin = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)gameProfile));
                headModel.visible = true;
                RenderType skullRenderType = RenderType.m_110470_((ResourceLocation)skin);
                headModel.render(stack, ItemDisplayContext.NONE, buffer.m_6299_(skullRenderType), pPackedLight, OverlayTexture.f_118083_);
                head2Model.visible = true;
                stack.m_85837_(0.0, 0.0, 0.01);
                head2Model.render(stack, ItemDisplayContext.NONE, buffer.m_6299_(skullRenderType), pPackedLight, OverlayTexture.f_118083_);
            }
            stack.m_85849_();
        });
    }
}

