/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IBlock;
import com.tacz.guns.block.AbstractGunSmithTableBlock;
import com.tacz.guns.block.entity.GunSmithTableBlockEntity;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.index.ClientBlockIndex;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GunSmithTableRenderer
implements BlockEntityRenderer<GunSmithTableBlockEntity> {
    public GunSmithTableRenderer(BlockEntityRendererProvider.Context context) {
    }

    public Optional<ClientBlockIndex> getIndex(GunSmithTableBlockEntity blockEntity) {
        ResourceLocation id = blockEntity.getId();
        if (id == null || id.equals((Object)DefaultAssets.EMPTY_BLOCK_ID)) {
            return Optional.empty();
        }
        return TimelessAPI.getClientBlockIndex(id);
    }

    public static Optional<ClientBlockIndex> getIndex(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IBlock) {
            IBlock iBlock = (IBlock)item;
            ResourceLocation id = iBlock.getBlockId(stack);
            if (id.equals((Object)DefaultAssets.EMPTY_BLOCK_ID)) {
                return Optional.empty();
            }
            return TimelessAPI.getClientBlockIndex(id);
        }
        return Optional.empty();
    }

    public void render(GunSmithTableBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.getIndex(blockEntity).ifPresent(index -> {
            BedrockModel model = index.getModel();
            ResourceLocation texture = index.getTexture();
            if (model == null) {
                return;
            }
            BlockState blockState = blockEntity.m_58900_();
            Block patt2467$temp = blockState.m_60734_();
            if (patt2467$temp instanceof AbstractGunSmithTableBlock) {
                AbstractGunSmithTableBlock block = (AbstractGunSmithTableBlock)patt2467$temp;
                if (!block.isRoot(blockState)) {
                    return;
                }
                Direction facing = (Direction)blockState.m_61143_((Property)AbstractGunSmithTableBlock.FACING);
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 1.5, 0.5);
                poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252392_.m_252977_(block.parseRotation(facing)));
                RenderType renderType = RenderType.m_110473_((ResourceLocation)texture);
                model.render(poseStack, ItemDisplayContext.NONE, renderType, combinedLightIn, combinedOverlayIn);
                poseStack.m_85849_();
            }
        });
    }

    public boolean shouldRenderOffScreen(GunSmithTableBlockEntity blockEntity) {
        return true;
    }
}

