/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.papi;

import com.google.common.collect.Maps;
import com.tacz.guns.client.model.papi.AmmoCountPapi;
import com.tacz.guns.client.model.papi.PlayerNamePapi;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class PapiManager {
    private static final Map<String, Function<ItemStack, String>> PAPI = Maps.newHashMap();

    public static void addPapi(String textKey, Function<ItemStack, String> function) {
        textKey = "%" + (String)textKey + "%";
        PAPI.put((String)textKey, function);
    }

    public static String getTextShow(String textKey, ItemStack stack) {
        String text = I18n.f_118934_.m_6834_(textKey);
        for (Map.Entry<String, Function<ItemStack, String>> entry : PAPI.entrySet()) {
            String placeholder = entry.getKey();
            String data = entry.getValue().apply(stack);
            text = text.replace(placeholder, data);
        }
        return text;
    }

    static {
        PapiManager.addPapi("player_name", new PlayerNamePapi());
        PapiManager.addPapi("ammo_count", new AmmoCountPapi());
    }
}

